# This script configures Microsoft Edge WebDriver, and makes any additional edge config changes.

$config_directory = "C:\ProgramData\grid-config"

function Main {
    Write-Log -message "Provisioning Edge" -level "INFO"

    Install-Edge-Webdriver
    Enable-Popups
}

function Install-Edge-Webdriver {
    # Microsoft WebDriver is now a Windows Feature on Demand. This command will install it
    Write-Log -level "INFO" -message "Installing Edge WebDriver"
    DISM.exe /Online /Add-Capability /CapabilityName:Microsoft.WebDriver~~~~0.0.1.0

    if($lastExitCode -ne 0) {
        $msg = "Problem installing Edge Webdriver. Exit Code: $lastExitCode"
        Write-Log -level "ERROR" -message $msg
        throw $msg
    } else {
        Write-Log -level "INFO" -message "Edge WebDriver installed"
    }
}

# Enable Popups - Disable Popup Blocker
function Enable-Popups {
    # https://getadmx.com/?Category=Windows_10_2016&Policy=Microsoft.Policies.MicrosoftEdge::AllowPopups
    # Note: Even though it says "AllowPopups" it actually means Allow Popup Blocker
    $microsoftEdgeRegPath = 'HKLM:\Software\Policies\Microsoft\MicrosoftEdge\Main'
    New-Item -Force -Path $microsoftEdgeRegPath
    New-ItemProperty -Force -Path $microsoftEdgeRegPath -Name AllowPopups -PropertyType String -Value "no"
}

Main
