# Configures Modules

param(
    [string]$grid_environment
)

$config_directory = "C:\ProgramData\grid-config"

##################
# CSharp Modules #
##################

$moduleDirectory = "$($config_directory)\modules"

# Create the directory
New-Item -type directory $moduleDirectory

# Download from S3
$zipName = "CBGModules.zip"
$path = "$moduleDirectory\$zipName"

Read-S3Object -BucketName "grid-artifacts" -Key "cbg_modules/$grid_environment/$zipName" -File "$path"

# Unzip
Expand-Archive -Path $path -DestinationPath $moduleDirectory

# Clean up the zip
Remove-Item -Path $path

######################
# Powershell Modules #
######################

# Grab the module paths available within Powershell
$moduleEnvPath = $($env:PSModulePath -split ';')

# Prefer the hardcoded path, if it's not in path, fall back to the first array element
# Not using the first element as when this runs on SYSTEM, it can be a weird path
$module_hardcode_path = "C:\Program Files\WindowsPowerShell\Modules"
if ($moduleEnvPath.Contains($module_hardcode_path))
{
    $modulePath = $module_hardcode_path
} else {
    $modulePath = $moduleEnvPath[0]
}

# Imports Custom Powershell Modules
function Custom-Import($name)
{
    $path = "$modulePath\$name"
    # Create a directory to hold the module. Modules need to be in a folder with same name.
    New-Item -Type Directory -Path $path

    # Move the file into that directory
    Move-Item -Path "$config_directory\$($name).psm1" -Destination $path

    # Powershell import
    Import-Module $name
}

# Import the modules

# CBGLogger
Custom-Import "CBGLogger"

# CBGAws
Custom-Import "CBGAws"

# PagerDuty
Custom-Import "CBGPagerDuty"
