# Deletes the Twitch folder, which stores Desktop Artifacts

function main {
    $path = "C:\Program Files\Twitch"

    log -level "INFO" -message "Preparing to remove $path"
    try {
        Remove-Item -Recurse -Force $path -ErrorAction Stop
    } catch [System.Management.Automation.ItemNotFoundException] {  # Ignore When Directory Not Found
    } catch {
        log -level "ERROR" -message "While removing item, encountered exception: $($_.Exception)"
    }

    # Make sure the directory still doesn't exist after removal
    if([System.IO.File]::Exists($path)){
        log -level "ERROR" -message "Attempted to remove $path but it still exists"
    } else {
        log -level "INFO" -message "Successfully removed $path"
    }
}

# Quick helper method to Write-Log which appends the file name
function log {
    param(
        [string]$message,
        [string]$level)

    Write-Log -level $level -message "delete_desktop_artifacts.ps1: $message"
}

main # Run the main function
