# Rotates Nginx Logs

function Main() {
    Rotate("C:\Program Files\nginx\logs\access.log")
    Rotate("C:\Program Files\nginx\logs\error.log")
}

function Rotate($logFilePath) {
    if(!(Test-Path -Path $logFilePath)) # Make sure the path exists before rotating it
    {
        $msg = "When running nginx log rotate, encountered: $logFilePath doesn't exist"
        Write-Log -level "WARN" -message $msg
        throw $msg
    }

    # will look like C:\Program Files\nginx\logs\access.log.0
    $rotatedPath = "$($logFilePath).0"
    Write-Log -level "DEBUG" -message "Rotating $logFilePath to $rotatedPath"

    Move-Item -Path $logFilePath -Destination $rotatedPath

    # Have Nginx move its logging reference back to access.log
    Write-Log -level "DEBUG" -message "Reopening Nginx Log Files"
    Start-Process -FilePath "nginx.exe" -WorkingDirectory "C:\Program Files\nginx" -ArgumentList "-s reopen" -Wait
    Start-Sleep -Seconds 1 # For safety...

    # Archive the file with the highest compression, overwrite the old one
    $compressPath = "$rotatedPath.zip"
    Write-Log -level "DEBUG" -message "Compressing $rotatedPath to $compressPath"
    Compress-Archive -Path $rotatedPath -DestinationPath $compressPath -Force -CompressionLevel Optimal
    Remove-Item -Path $rotatedPath # Clean up
    Write-Log -level "INFO" -message "Nginx Logs Rotated to $rotatedPath"
}

Main
