param(
    [string]$gridEnvironment # Provides which environment to download the binaries from
)

# Screen Resolution and App Launcher downloads.

Write-Log -message "Downloading Grid Helpers" -level "INFO"

$config_directory = "C:\ProgramData\grid-config"

function Get-Helper() {
    param([string]$name, [string]$gridEnvironment)
    $fileName = "$name.zip"
    $path = "$($config_directory)\$($fileName)"

    Write-Log -message "Downloading grid helpers to $path" -level "DEBUG"
    try {
        Read-S3ObjectWithWait -s3Uri "s3://grid-artifacts/$name/$gridEnvironment/$fileName" -localPath "$path"
    } catch {
        Write-Log -level "ERROR" -message "While downloading grid helpers, encountered exception: $($_.Exception.Message)"
        throw $_
    }

    Write-Log -message "Extracting contents to $path"
    Expand-Archive $path -Force -DestinationPath $config_directory # Unzip

    # Clean Up
    Remove-Item -Path $path
}

Get-Helper -name "ResolutionConsole" -gridEnvironment $gridEnvironment
Get-Helper -name "app_launcher" -gridEnvironment $gridEnvironment
