# This script installs Python and the AWS CLI
$ErrorActionPreference = "Stop" # Stop on any exception
$config_directory = "C:\ProgramData\grid-config"

Write-Host "Preparing to install the AWS CLI"
$aws_url = "https://s3.amazonaws.com/aws-cli/AWSCLI64.msi" # URL where CLI can be downloaded
$aws_path = "$config_directory\AWSCLI64.msi" # Where to store it
(New-Object System.Net.WebClient).DownloadFile($aws_url, $aws_path) # Download it

# Check to make sure the path exists after downloading
if (-not (Test-Path $aws_path)) {
  throw "ERROR: Did not find the path $($aws_path) - it may have not downloaded."
}

# Install It
Start-Process msiexec.exe -Wait -ArgumentList "/I $($aws_path) /quiet"

# Reload Path, so that the CLI can be called
$env:Path = [System.Environment]::GetEnvironmentVariable("Path","Machine") + ";" + [System.Environment]::GetEnvironmentVariable("Path","User")

######################
# Set the AWS Region #
######################

# Grab the region the instance is running in
try {
  $region = Get-AWS-Region
} catch {
  Write-Log -level "ERROR" -message "Problem fetching AWS Region. Defaulting region to us-west-2. Encountered $_" # Want a page
  $region = "us-west-2"
}

# Set the AWS CLI to that region
try {
  Write-Log -level "DEBUG" -message "Setting AWS Configure Region to $region"
  aws configure set region $region
} catch {
  Write-Log -level "ERROR" -message "Problem running aws configure. Exception: $_"
  throw $_
}
