# This script will Download & Install Nginx
$config_directory = "C:\ProgramData\grid-config"

function Main() {
    $path = Download
    $installedPath = Install($path)
    Add-Firewall-Rule("$installedPath\nginx.exe")
}

# Downloads Nginx
# @return [String] The path to the folder where the installer was saved
function Download() {
    $version = "1.15.12"
    $path = "$config_directory\nginx-$version.zip"

    # Download
    Write-Log -level "DEBUG" -message "Downloading Nginx to $path"
    try {
        Read-S3ObjectWithWait -s3Uri "s3://grid-artifacts/nginx/nginx-$version.zip" -localPath "$path"
    } catch {
        Write-Log -level "ERROR" -message "While downloading nginx, encountered exception: $($_.Exception.Message)"
        throw $_
    }

    # Make sure the file exists
    if (!(Test-Path $path))
    {
        $errMsg = "After nginx download, could not find path $path"
        Write-Log -level "ERROR" -message $errMsg
        throw $errMsg
    }

    $folderName = "nginx"
    $folderPath = "$config_directory\$folderName"

    # Unzip
    Expand-Archive $path -DestinationPath $folderPath
    Remove-Item $path

    # Extracting contains another folder with nginx-$version, so include that
    return "$folderPath\nginx-$version"
}

# Installs Nginx from the path
# @param [String] path The path to where installation folder exists
function Install($path) {
    $nginxPath = "C:\Program Files\nginx"
    $configPath = "$config_directory\nginx.conf"
    Move-Item -Path $path -Destination $nginxPath

    # Move the config, overwriting the default
    Move-Item -Path $configPath -Destination "$nginxPath\conf\nginx.conf" -Force

    Write-Log -level "INFO" -message "Nginx Installed to $nginxPath"
    return "$nginxPath"
}

# Sets a firewall rule to allow inbound to nginx
# @param $exePath The path to the exe
function Add-Firewall-Rule($exePath) {
    Write-Log -level "DEBUG" -message "Adding firewall rule for nginx.exe, Path: $exePath"
    New-NetFirewallRule -Program "$exePath" -Action Allow -Profile Any -DisplayName "nginx" -Description "Nginx used for Selenium Grid" -Direction Inbound
    Write-Log -level "INFO" -message "nginx.exe Firewall rule added"
}

Main

