# This script will Download & Install Sysmon Agent
# Helps for Security Logs
# https://docs.microsoft.com/en-us/sysinternals/downloads/sysmon
$config_directory = "C:\ProgramData\grid-config"

function Main() {
    $path = Download
    Install($path)
}

# Downloads Sysmon Agent
# @return [String] The path to the folder where the installer was saved
function Download() {
    $path = "$config_directory\Sysmon.zip"

    try {
        Read-S3ObjectWithWait -s3Uri "s3://grid-artifacts/Sysmon_4_19_19.zip" -localPath "$path"
    } catch {
        Write-Log -level "ERROR" -message "While downloading Sysmon, encountered exception: $($_.Exception.Message)"
        throw $_
    }

    # Make sure the file exists
    if (!(Test-Path $path))
    {
        $errMsg = "After download, could not find path $path"
        Write-Log -level "ERROR" -message $errMsg
        throw $errMsg
    }

    $folderName = "Sysmon"
    $folderPath = "$config_directory\$folderName"

    # Unzip
    Expand-Archive $path -DestinationPath $folderPath
    return $folderPath
}

# Installs Sysmon Agent from the path
# @param [String] path The path to where installation folder exists
function Install($path) {
    $filepath = Resolve-Path "$path\Sysmon64.exe"
    $arguments = "-accepteula -i"

    Write-Log -level "DEBUG" -message "Installing Sysmon Agent"

    # Start Install
    $proc = Start-Process $filepath.path -PassThru -Wait -NoNewWindow -ArgumentList $arguments

    # Make sure install was successful
    if ($proc.ExitCode -ne 0)
    {
        $errMsg = "Sysmon Agent Installation exited with unexpected code: $($proc.ExitCode)"
        Write-Log -level "ERROR" -message $errMsg
        throw $errMsg
    }

    Write-Log -level "INFO" -message "Sysmon Agent Installed - exit code $($proc.ExitCode)"
}

Main
