# Contains logging utilities

# Writes a log to STDOUT and to Syslog
# @param [String] message The message to log
# @param [String] level The level of log, default to INFO
Function New-PagerDutyIncident() {
    param(
        [string]$message,
        [string]$level = "error")

    $config_directory = "C:\ProgramData\grid-config"
    $moduleDirectory = "$($config_directory)\modules"
    $moduleName = "CBGModules.dll"

    Add-Type -Path "$moduleDirectory\$moduleName"
    [CBGModules.PagerDuty]::Trigger($message, $level)
}

export-modulemember -function New-PagerDutyIncident
