# Runs Chef

$config_directory = "C:\ProgramData\grid-config"
$ErrorActionPreference = "Stop" # Stop on any error

function Main()
{
    Write-Log -level "INFO" -message "Running Chef"

    # Store the current running directory so after we can go back
    # Trim the newline at the end :)
    $originalDirectory = (((pwd).Path) | Out-String).Trim()

    # Go into the chef directory to run Chef Solo
    # It doesn't appear we can simply apply it a path when using -z
    cd "$config_directory\chef"

    chef-client -z --chef-license accept-silent --no-color | ForEach-Object -Process {
        # For all stdout, redirect it to Write-Log function
        $logMsg = $_ # Assign the output to a variabls

        # log output in a chef run is terrible. Some lines include level, others don't
        # even worse, sometimes source code is outputted when ohai creates files, like:
        # Ohai::Log.warn('AWS SDK Gem is not installed, unable to retrieve tags')
        # so parsing becomes difficult
        # improvement: https://jira.xarth.tv/browse/DELIVERY-2529
        $logLevel = "UNKNOWN"

        # Write the log if the string is not null or empty
        if (![string]::IsNullOrEmpty($logMsg))
        {
            Write-Log -level "$logLevel" -message "$logMsg" -application "chef"
        }
    }

    if ("$lastExitCode" -ne "0") {
        Write-Log -level "ERROR" -message "Unexpected error code running Chef: $lastExitCode. Exiting as failure" -application "chef"
        exit 1
    }

    # Go back
    cd $originalDirectory
}

Main
