# Launches the Selenium Grid binary
param(
    [string]$hubHost
)

$config_directory = "C:\ProgramData\grid-config"
$logDirectory = "C:\Users\selenium\AppData\Local\Twitch\Grid\Logs"

# Make sure user provided a hub host
if ([string]::IsNullOrWhiteSpace($hubHost)) {
    $msg = "Must provide the hub's host. Example: cbg-hub.us-west2.justin.tv"
    Write-Log -level "ERROR" -message $msg
    throw $msg
}

################
# Launch Nginx #
################
Start-Process -FilePath "nginx.exe" -WorkingDirectory "C:\Program Files\nginx"

##############
# Get EC2 IP #
##############
try {
    $resp = Invoke-WebRequest -Uri "http://169.254.169.254/latest/meta-data/local-ipv4" -UseBasicParsing
} catch {
    $msg = "Problem fetching EC2 IP. Error: $_"
    Write-Log -level "ERROR" -message $msg
    throw $msg
}

# Open the content, make sure it's there
$ec2IP = $resp.Content
if ([string]::IsNullOrWhiteSpace($ec2IP)) {
    $msg = "Problem fetching EC2 IP. Response Status Code: $($resp.StatusCode), Body: $($resp.Content)"
    Write-Log -level "ERROR" -message $msg
    throw $msg
}

########################
# Launch Selenium Grid #
########################

# Build Arguments
$hubUrl = "http://${hubHost}:80/grid/register"
# Remote Host is used to let Selenium Hub know a custom port. Use Nginx instead of the Sel Server Port
$remoteHost = "http://$($ec2IP):80"
$arguments = `
  "-Djava.util.logging.config.file=$config_directory\selenium_logging.config" `
  + " -Dcbg.config.path=cbg_config.yaml" `
  + " -Dwebdriver.chrome.driver=$config_directory\chromedriver_win32\chromedriver.exe" `
  + " -Dwebdriver.gecko.driver=$config_directory\geckodriver\geckodriver.exe" `
  + " -Dwebdriver.firefox.logfile=$logDirectory\geckodriver.log" `
  + " -Dwebdriver.ie.driver=$config_directory\iedriver\IEDriverServer.exe" `
  + " -cp `"*`" org.openqa.grid.selenium.GridLauncherV3" `
  + " -role node" `
  + " -hub $hubUrl" `
  + " -nodeConfig $config_directory\nodeConfig.json" `
  + " -remoteHost $remoteHost" `
  + " -debug"

# Friendly Output
echo "Starting Grid against $hubHost, arguments: $arguments"
echo "Prompt will be held, output will be redirected"

# Start Process
Start-Process -FilePath "java.exe" `
  -WorkingDirectory "$config_directory\cbg_bin" `
  -ArgumentList $arguments `
  -NoNewWindow `
  -Wait `
  -RedirectStandardError  "$logDirectory\output.log" `
  -RedirectStandardOutput "$logDirectory\err_output.log"
