# Selenium Extensions
We've found requirements within Twitch to customize the Selenium Grid Binary.

This include:
- Custom Capability matcher for Grid. Nodes can define their:
  - osPlatform
  - osVersion
- Sending Logs to Central Syslog

## Build
A script is available that'll build the package, download the Selenium dependency, and zip the binaries up.

```
./build.sh
```

If you prefer to build only the Java JAR manually:

```
mvn clean package
```

## Run
If you've used the above build script, change directory into the cbg_binary folder and run:
```
java -cp "*" org.openqa.grid.selenium.GridLauncherV3 -role hub -hubConfig hubconfig.json
```

If you built it manually, you'll need to download the Selenium Binary, place it in the same directory as the JAR, and run the above command.

## Deploy
This is a manual process at the moment.

After running the above build script, a zip file will be created.

This should be uploaded to S3:
Amazon S3 -> grid-artifacts -> cbg_bin -> cbg_bin.zip

The nodes will download this binary upon provisioning.

Support by environment is currently not supported.

## Details

### Extension Strategy
It should be aimed to do as little of modification as possible to the Selenium binary.
This will help with maintenance as we bump the versions.

We currently distribute a JAR that has only a few classes overrriden to add functionality.
From there, the CBG Custom Extension JAR must be in the same folder as the Selenium JAR. It expects that dependency.

By utilizing classpath (`java -cp "*"`), we are saying include all jars within this folder, and the main method to launch is within GridLauncherV3.

We are limited in what we can override. Overriding the main function cannot be done to my knowledge.
Private methods also cannot be overridden.

### Upgrading Selenium
Upgrading Selenium should be as simple as putting the new version's jar in the folder where the CBG jar is.
The [build script](build.sh) should be updated to download the new version.

### Custom Capability Matcher
We provide a custom capability matcher to Grid, which adds the following properties:
- osPlatform
- osVersion

This allows nodes to specify these capabilities within their nodeConfig.json file.

We support this so that clients can send things like osPlatform: Windows, osVersion: 10.

Previously strategies utilized platform: WIN8; however, platform is used by GeckoDriver, so we are limited in our customization.

### Central Syslog Logging
It has become important to send logs to our central syslog. That way we have a centralized place to store and monitor logs.

In this jar, we create a custom logger handler. That handler will provide the ability to send logs to syslog.

DEBUG/TRACE logs are currently **not supported** to send to syslog. Sensitive data, such as values sent via sendKeys and cookies with authtokens could be sensitive.
In the future, we can add support that will strip out the particular log lines that are sensitive.

#### Configuring the logger
A log config file can be defined, that specifies the handlers and properties for logging.

When launching the jar application, append the log file as a property, such as:
`java -Djava.util.logging.config.file=selenium_logging.config`

An example of the logging config file:
```
handlers = com.cbg.selenium.logger.CentralSysLogHandler
com.cbg.selenium.logger.CentralSysLogHandler.instanceID = i-eg835n38
```

You can add multiple log handlers by space separating, such as:
`handlers = com.cbg.selenium.logger.CentralSysLogHandler java.util.logging.ConsoleHandler`

### PagerDuty
We support triggering PagerDuty Alerts/Events on WARNING/SEVERE messages.

Add to your logging config file:
```
handlers = com.cbg.selenium.logger.PagerDutyLogHandler
com.cbg.selenium.logger.PagerDutyLogHandler.triggerPagerDutyEvents = true
```

To disable it, set to false:
```
handlers = com.cbg.selenium.logger.PagerDutyLogHandler
com.cbg.selenium.logger.PagerDutyLogHandler.triggerPagerDutyEvents = false
```

By default, if you include the handler, it is enabled.

### Other Configuration
You can specify other configuration values in YAML format. Example cbg_config.yaml:
```
instanceID: i-35836nej3
pagerdutyServiceKey: MY_SERVICE_KEY
```

You can then have this jar read it by passing the following environment variable:
```
-Dcbg.config.path="./path/to/file.yaml"
```

Example:
```
java -Dcbg.config.path="./cbg_config.yaml" -cp *:. org.openqa.grid.selenium.GridLauncherV3
```

## Resources
These articles influenced development:
- [Custom Capability Matcher](https://rationaleemotions.wordpress.com/2014/01/19/working-with-a-custom-capability-matcher-in-the-grid/)
- [Java Logging Configuration](http://tutorials.jenkov.com/java-logging/configuration.html)
- [Java Logging: Overview](https://docs.oracle.com/javase/8/docs/technotes/guides/logging/overview.html)
