#!/bin/bash
# This script will build the Jar for capability-matcher and prepare for release

# For finding the dependent Selenium Version
SELENIUM_VERSION="3.141"
SELENIUM_MINOR_VERSION="59"
SELENIUM_FULL_VERSION="$SELENIUM_VERSION.$SELENIUM_MINOR_VERSION" # ex: 3.11.0

# Where to store the file
OUTPUT_BIN_DIRECTORY="cbg_bin"

# Where to output the ZIP
ZIP_NAME="cbg_bin.zip"

# Stores where the user currently is when running the command
ORIGINAL_DIRECTORY=$(pwd)

# Delete old contents to make sure it's clean
rm "$ZIP_NAME"
rm -rf $OUTPUT_BIN_DIRECTORY
mkdir $OUTPUT_BIN_DIRECTORY

#####################
# Download Selenium #
#####################

echo -e "\nDownloading Selenium"
SELENIUM_DOWNLOAD_FILENAME="selenium-server-standalone-$SELENIUM_FULL_VERSION.jar"
SELENIUM_DOWNLOAD_PATH="http://selenium-release.storage.googleapis.com/$SELENIUM_VERSION/$SELENIUM_DOWNLOAD_FILENAME"

cd $OUTPUT_BIN_DIRECTORY
curl $SELENIUM_DOWNLOAD_PATH -o "$SELENIUM_DOWNLOAD_FILENAME"

# Make sure the file downloaded
if [ ! -f "$SELENIUM_DOWNLOAD_FILENAME" ]; then
  echo -e "\n\nERROR! There was a problem downloading the selenium jar within $(pwd)"
  exit 1
fi

cd $ORIGINAL_DIRECTORY # Go back to original directory

#################
# Build the Jar #
#################

echo -e "\nBuilding Jar"
mvn clean package

###################
# Move Jar to Bin #
###################

echo -e "\nMoving Jar to folder"
JAR_FILENAME=$(ls target/ | grep "with-dependencies.jar")

# If filename is blank
if [ -z "$JAR_FILENAME" ]
then
  echo -e "\n\nERROR! Could not find with-dependencies jar!"
  exit 1
fi

cp target/$JAR_FILENAME $OUTPUT_BIN_DIRECTORY/$JAR_FILENAME

###########################
# Zip up for Distribution #
###########################

echo -e "\nZipping up for distribution"
zip -r $ZIP_NAME $OUTPUT_BIN_DIRECTORY

echo -e "\n\nDone! Your next step is to upload this to S3: $(pwd)/$ZIP_NAME"
