package com.cbg.selenium.capabilities;

import java.util.Map;
import java.util.logging.Logger;

/**
 * Object that contains all of Cross Browser Grid's Desktop Capabilities
 */
public class DesktopCapabilities {

    private String artifactURL; // Stores the url to download the artifact
    private String binaryRelativePath; // Stores the relative path to the binary
    private Map<String, Object> desktopCapabilities; // Stores a map of all desktop capabilities
    private final String capabilityIdentifier = "desktopApp"; // Identifies the name provided in the capabilities
    private static final Logger log = Logger.getLogger(DesktopCapabilities.class.getName());

    /**
     * Constructs a DesktopCapabilities Object
     * @param cbgCapabilites The parent cbgCapabilities Object
     */
    public DesktopCapabilities(Map<String, Object> cbgCapabilites) {
        if (!cbgCapabilites.containsKey(capabilityIdentifier)) {
            log.fine("Not creating DesktopCapabilities object as the capability identifier " + capabilityIdentifier + " was not provided.");
            return; // cbgCapabilities doesn't contain the desktop caps. Return
        }

        if (!(cbgCapabilites.get(capabilityIdentifier) instanceof Map)) { // If it is NOT an instanceOf Map
            log.warning("Not creating DesktopCapabilities object as the capabilities were not an instance of a map"); // This is not expected
            return; // Protect against TypeCast issues and return
        }

        desktopCapabilities = (Map) cbgCapabilites.get(capabilityIdentifier);
        this.artifactURL = (String) desktopCapabilities.get("artifactURL");
        this.binaryRelativePath = (String) desktopCapabilities.get("binaryRelativePath");
    }

    /**
     * @return The URL to download the artifact
     */
    public String getartifactURL() {
        return artifactURL;
    }

    /**
     * @return The relative path to where the binary is stored
     */
    public String getBinaryRelativePath() {
        return binaryRelativePath;
    }

    /**
     * @return If the object is completely empty in attributes
     */
    public boolean empty() {
        return (artifactURL == null && binaryRelativePath == null); // TODO: Dynamically do this?
    }
}
