package com.cbg.utils;

import com.cbg.selenium.objects.CBGCapabilities;
import com.cbg.selenium.objects.ChromeOptCapabilities;

import java.util.logging.Logger;

/**
 * Utilities and Helper Methods pertaining to ChromeDriver Option Objects
 */
public class ChromeOptUtils {
    private static final Logger log = Logger.getLogger(ChromeOptUtils.class.getName());

    /**
     * Merges custom Cross Browser Grid capabilities into ChromeOptions
     * An example is when we need to provide ChromeDriver with a desktop application's path.
     * @param cbgCaps The Cross Browser Grid capabilities
     * @param cOpts The ChromeDriver Options Object to be modified
     */
    public static ChromeOptCapabilities mergeDesktopBinaryFromCapabilities(CBGCapabilities cbgCaps,
                                                                           ChromeOptCapabilities cOpts,
                                                                           String desktopAppStorageFolder) {
        // If the Desktop Capabilities or its path are null, or empty, return
        if (cbgCaps == null ||
                cbgCaps.getDesktopCapabilities() == null ||
                cbgCaps.getDesktopCapabilities().getBinaryRelativePath() == null ||
                cbgCaps.getDesktopCapabilities().getBinaryRelativePath().isEmpty() ) {
            return cOpts;
        }

        // If ChromeOptions already has a binary path included (not null or not empty), return
        if(cOpts.getBinaryPath() != null && !cOpts.getBinaryPath().isEmpty()) { return cOpts; }

        // Grab the path and set it
        String path = cbgCaps.getDesktopCapabilities().getBinaryRelativePath();
        cOpts.setBinaryPath(String.format("%s\\%s", desktopAppStorageFolder, path));
        return cOpts;
    }
}
