//package com.cbg.selenium.capabilities;
//
//import static org.junit.Assert.*;
//import java.util.TreeMap;
//import com.cbg.selenium.objects.CBGCapabilities;
//
//import org.junit.Test;
//
//
//public class DesktopCapabilitiesTest {
//    @Test
//    public void testNoDesktopCaps() {
//        TreeMap<String, Object> caps = new TreeMap<String, Object>();
//        TreeMap<String, Object> cbgInputCaps = new TreeMap<String, Object>();
//        caps.put("cbg", cbgInputCaps); // Create caps with cbg, but no desktop
//
//        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
//
//        assertFalse(cbgCaps.empty());
//        assertTrue(cbgCaps.getDesktopCapabilities().empty());
//    }
//
//    @Test
//    public void testCBGCapsWithDesktop() {
//        String testWebsite = "http://www.test.com";
//        String testPath = "C:\\Test";
//
//        CBGCapabilities cbgCaps = createCBGCapsWithDesktop(testWebsite, testPath);
//        assertFalse(cbgCaps.empty()); // Should not be empty
//        assertFalse(cbgCaps.getDesktopCapabilities().empty()); // Should not be empty
//        assertTrue(cbgCaps.getDesktopCapabilities() instanceof DesktopCapabilities); // CBGCaps should return a DesktopCapability
//
//        assertEquals(cbgCaps.getDesktopCapabilities().getartifactURL(), testWebsite);
//        assertEquals(cbgCaps.getDesktopCapabilities().getBinaryRelativePath(), testPath);
//    }
//
//    public static CBGCapabilities createCBGCapsWithDesktop(String url, String path) {
//        CBGCapabilities cbgCaps = new CBGCapabilities(createDesktopCaps(url, path));
//        return cbgCaps;
//    }
//
//    public static TreeMap<String, Object> createDesktopCaps(String url, String path) {
//        TreeMap<String, Object> caps = new TreeMap<String, Object>();
//        TreeMap<String, Object> cbgCapsInput = new TreeMap<String, Object>();
//        TreeMap<String, Object> desktopCapsInput = new TreeMap<String, Object>();
//
//        desktopCapsInput.put("artifactURL", url);
//        desktopCapsInput.put("binaryRelativePath", path);
//
//        cbgCapsInput.put("desktopApp", desktopCapsInput);
//        caps.put("cbg", cbgCapsInput);
//
//        return caps;
//    }
//}
