package com.cbg.selenium.capability_matcher;

import static org.junit.Assert.*;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;

public class capabilityMatcherTest {
	
	private CBGCapabilityMatcher matcher = new CBGCapabilityMatcher();
	private static String osPlatform = "osPlatform";
	private static String osVersion = "osVersion";

	@Test
	public void testPlatform() {
		Map<String, Object> nodeCapability = new HashMap<String, Object>();
		Map<String, Object> requestedCapability = new HashMap<String, Object>();
		
		nodeCapability.put(osPlatform, "Windows");
		requestedCapability.put(osPlatform, "Windows");
		assertTrue(matcher.matches(nodeCapability, requestedCapability));
		
		nodeCapability.put(osPlatform, "Windows");
		requestedCapability.put(osPlatform, "Linux");
		assertFalse(matcher.matches(nodeCapability, requestedCapability));
	}
	
	@Test
	public void testPlatformCasing() {
		Map<String, Object> nodeCapability = new HashMap<String, Object>();
		Map<String, Object> requestedCapability = new HashMap<String, Object>();
		
		nodeCapability.put(osPlatform, "WINDOWS");
		requestedCapability.put(osPlatform, "windows");
		assertTrue(matcher.matches(nodeCapability, requestedCapability));
	}
	
	@Test
	public void testBlankReqPlatform() {
		Map<String, Object> nodeCapability = new HashMap<String, Object>();
		Map<String, Object> requestedCapability = new HashMap<String, Object>();
		
		nodeCapability.put(osPlatform, "Windows");
		requestedCapability.put(osPlatform, "");
		assertFalse(matcher.matches(nodeCapability, requestedCapability));
	}
	
	@Test
	public void testVersionCasing() {
		Map<String, Object> nodeCapability = new HashMap<String, Object>();
		Map<String, Object> requestedCapability = new HashMap<String, Object>();
		
		nodeCapability.put(osVersion, "10 Enterprise");
		requestedCapability.put(osVersion, "10 enterprise");
		assertTrue(matcher.matches(nodeCapability, requestedCapability));
	}
	
	@Test
	public void testVersion() {
		Map<String, Object> nodeCapability = new HashMap<String, Object>();
		Map<String, Object> requestedCapability = new HashMap<String, Object>();
		
		nodeCapability.put(osVersion, "10");
		requestedCapability.put(osVersion, "10");
		assertTrue(matcher.matches(nodeCapability, requestedCapability));
		
		nodeCapability.put(osVersion, "10");
		requestedCapability.put(osVersion, "8");
		assertFalse(matcher.matches(nodeCapability, requestedCapability));
	}
	
	@Test
	public void testBlankReqVersion() {
		Map<String, Object> nodeCapability = new HashMap<String, Object>();
		Map<String, Object> requestedCapability = new HashMap<String, Object>();
		
		nodeCapability.put(osVersion, "10");
		requestedCapability.put(osVersion, "");
		assertFalse(matcher.matches(nodeCapability, requestedCapability));
	}
	
	@Test
	public void testPlatformAndVersion() {
		Map<String, Object> nodeCapability = new HashMap<String, Object>();
		Map<String, Object> requestedCapability = new HashMap<String, Object>();
		
		nodeCapability.put(osPlatform, "Windows");
		nodeCapability.put(osVersion, "10");
		requestedCapability.put(osPlatform, "Windows");
		requestedCapability.put(osVersion, "10");
		assertTrue(matcher.matches(nodeCapability, requestedCapability));
		
		nodeCapability.put(osPlatform, "Windows");
		nodeCapability.put(osVersion, "10");
		requestedCapability.put(osPlatform, "Windows");
		requestedCapability.put(osVersion, "8");
		assertFalse(matcher.matches(nodeCapability, requestedCapability));
	}
	
	@Test
	public void noRequestedPlatformOrVersion() {
		Map<String, Object> nodeCapability = new HashMap<String, Object>();
		Map<String, Object> requestedCapability = new HashMap<String, Object>();
		
		nodeCapability.put(osPlatform, "Windows");
		nodeCapability.put(osVersion, "10");
		assertTrue(matcher.matches(nodeCapability, requestedCapability));
	}
	
	@Test
	public void partialPlatformOrVersion() {
		Map<String, Object> nodeCapability = new HashMap<String, Object>();
		Map<String, Object> requestedCapability = new HashMap<String, Object>();
		
		nodeCapability.put(osPlatform, "Windows");
		nodeCapability.put(osVersion, "10");
		
		requestedCapability.put(osPlatform, "Windows");
		assertTrue(matcher.matches(nodeCapability, requestedCapability));
		
		requestedCapability.remove(osPlatform);
		requestedCapability.put(osVersion, "10");
		assertTrue(matcher.matches(nodeCapability, requestedCapability));
	}
	
	@Test
	// Tests if user requested the osPlatform capability, but no nodes have that key
	// Previous bug would return a NullPointerException if this condition occurred
	public void nodeMissingPlatformCapability()
	{
		Map<String, Object> nodeCapability = new HashMap<String, Object>();
		Map<String, Object> requestedCapability = new HashMap<String, Object>();
		
		requestedCapability.put(osPlatform, "Windows");
		assertFalse(matcher.matches(nodeCapability, requestedCapability));
	}
	
	@Test
	// Tests if user requested the osVersion capability, but no nodes have that key
	// Previous bug would return a NullPointerException if this condition occurred
	public void nodeMissingVersionCapability()
	{
		Map<String, Object> nodeCapability = new HashMap<String, Object>();
		Map<String, Object> requestedCapability = new HashMap<String, Object>();
		
		requestedCapability.put(osVersion, "10");
		assertFalse(matcher.matches(nodeCapability, requestedCapability));
	}
}
