//package com.cbg.selenium.objects;
//
//import static org.junit.Assert.*;
//import java.util.TreeMap;
//import java.util.Map;
//import java.util.LinkedHashMap;
//
//import com.cbg.selenium.capabilities.DesktopCapabilitiesTest;
//import com.cbg.utils.ChromeOptUtils;
//
//import org.junit.Test;
//
//public class ChromeOptCapabilitiesTest {
//
//    private final String desktopAppStorageFolder = "C:\\Program Files\\Twitch"; // TODO: Store in a config file. QE-2197
//    private String testURL = "http://www.test.com";
//    private String testPath = "dist\\test.exe";
//    private String cOptsKey = "chromeOptions";
//    private String cOptsBinaryKey = "binary";
//
//    @Test
//    // Ensure providing desktop capabilities will be returned from ChromeDriverOpts
//    public void testProvidingDesktopCaps() {
//        TreeMap<String, Object> caps = DesktopCapabilitiesTest.createDesktopCaps(testURL, testPath);
//        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
//        Map<String, Object> newCaps;
//
//        ChromeOptCapabilities cOpts = new ChromeOptCapabilities(caps);
//        ChromeOptUtils.mergeDesktopBinaryFromCapabilities(cbgCaps, cOpts);
//        newCaps = cOpts.getChromeOptions();
//
//        assertTrue(newCaps.containsKey(cOptsBinaryKey));
//        assertEquals(newCaps.get(cOptsBinaryKey), getChromeDriverBinaryFullPath(testPath));
//    }
//
//    @Test
//    // Ensure providing desktop capabilities adds it to the full Selenium Capabilities passed to the node
//    public void fullCapabilitiesIncludesChromeDriver() {
//        TreeMap<String, Object> caps = DesktopCapabilitiesTest.createDesktopCaps(testURL, testPath);
//        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
//        Map<String, Object> newCaps;
//
//        ChromeOptCapabilities cOpts = new ChromeOptCapabilities(caps);
//        ChromeOptUtils.mergeDesktopBinaryFromCapabilities(cbgCaps, cOpts);
//        newCaps = cOpts.getFullCapabilities(caps);
//
//        assertTrue(newCaps.containsKey(cOptsKey));
//
//        LinkedHashMap<String, Object> decodedChromeDriverCaps = new LinkedHashMap<String, Object>();
//        decodedChromeDriverCaps.putAll((Map) newCaps.get(cOptsKey));
//
//        assertTrue(decodedChromeDriverCaps.containsKey(cOptsBinaryKey));
//        assertEquals(decodedChromeDriverCaps.get(cOptsBinaryKey), getChromeDriverBinaryFullPath(testPath));
//    }
//
//    @Test
//    // Cases where a user passes chromeoptions, make sure this doesn't get lost when we generate
//    public void existingCOptsGetAppended() {
//        TreeMap<String, Object> caps = DesktopCapabilitiesTest.createDesktopCaps(testURL, testPath);
//        LinkedHashMap<String, Object> existingChromeOpts = mockChromeOptions();
//        caps.put(cOptsKey, existingChromeOpts);
//
//        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
//        Map<String, Object> newCaps;
//
//        ChromeOptCapabilities cOpts = new ChromeOptCapabilities(caps);
//        ChromeOptUtils.mergeDesktopBinaryFromCapabilities(cbgCaps, cOpts);
//        newCaps = cOpts.getFullCapabilities(caps);
//
//        System.out.println(newCaps);
//
//        assertTrue(newCaps.containsKey(cOptsKey));
//        LinkedHashMap<String, Object> decodedChromeDriverCaps = new LinkedHashMap<String, Object>();
//        decodedChromeDriverCaps.putAll((Map) newCaps.get(cOptsKey));
//
//        // It still has the args you passed
//        assertTrue(decodedChromeDriverCaps.containsKey(mockChromeArgument().get("name")));
//        assertEquals(decodedChromeDriverCaps.get(mockChromeArgument().get("name")), mockChromeArgument().get("value"));
//
//        // It has the newly appended binary that was built
//        assertTrue(decodedChromeDriverCaps.containsKey("binary"));
//        assertEquals(decodedChromeDriverCaps.get(cOptsBinaryKey), getChromeDriverBinaryFullPath(testPath));
//    }
//
//    @Test
//    // When user provides no desktop capabilities and no chromeopts, it should never be added
//    public void noDesktopCapsAndNoChromeOpts() {
//        TreeMap<String, Object> caps;
//        caps = cbgCapabilitiesTest.getCBGCapabilitiesNoDesktop();
//
//        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
//        Map<String, Object> newCaps;
//
//        ChromeOptCapabilities cOpts = new ChromeOptCapabilities(caps);
//        ChromeOptUtils.mergeDesktopBinaryFromCapabilities(cbgCaps, cOpts);
//        newCaps = cOpts.getFullCapabilities(caps);
//
//        assertFalse(newCaps.containsKey(cOptsKey));
//    }
//
//    @Test
//    // User has chrome caps, but did not provide desktop caps
//    public void noDesktopCapsIncludedChromeOpts() {
//        TreeMap<String, Object> caps;
//        caps = cbgCapabilitiesTest.getCBGCapabilitiesNoDesktop();
//        caps.put(cOptsKey, mockChromeOptions());
//
//        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
//        Map<String, Object> newCaps;
//
//        ChromeOptCapabilities cOpts = new ChromeOptCapabilities(caps);
//        ChromeOptUtils.mergeDesktopBinaryFromCapabilities(cbgCaps, cOpts);
//        newCaps = cOpts.getFullCapabilities(caps);
//
//        assertTrue(newCaps.containsKey(cOptsKey));
//
//        LinkedHashMap<String, Object> decodedChromeDriverCaps = new LinkedHashMap<String, Object>();
//        decodedChromeDriverCaps.putAll((Map) newCaps.get(cOptsKey));
//
//        assertFalse(decodedChromeDriverCaps.containsKey("binary"));
//        assertTrue(decodedChromeDriverCaps.containsKey(mockChromeArgument().get("name")));
//        assertEquals((decodedChromeDriverCaps.get(mockChromeArgument().get("name"))), mockChromeArgument().get("value"));
//    }
//
//    @Test
//    // Tests when the user provided no CBG, no Desktop, no Chrome Capabilities
//    // Catch things like null exceptions
//    public void noCBGCaps() {
//        TreeMap<String, Object> caps = new TreeMap<String, Object>();
//        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
//        Map<String, Object> newCaps;
//
//        ChromeOptCapabilities cOpts = new ChromeOptCapabilities(caps);
//        ChromeOptUtils.mergeDesktopBinaryFromCapabilities(cbgCaps, cOpts);
//        newCaps = cOpts.getFullCapabilities(caps);
//
//        assertFalse(newCaps.containsKey(cOptsKey));
//    }
//
//    @Test
//    // User already provided a binary path, it should not overwrite it
//    public void existingBinaryInChromeCapabilities() {
//        TreeMap<String, Object> caps = DesktopCapabilitiesTest.createDesktopCaps(testURL, testPath);
//        LinkedHashMap<String, Object> cBinOpts = new LinkedHashMap<String, Object>();
//
//        String existingPath = "C:\\Already\\Exists";
//        cBinOpts.put(cOptsBinaryKey, existingPath); // Add an empty binary to the hash
//        caps.put(cOptsKey, cBinOpts); // Insert chromeOpts with a binary
//
//        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
//
//        ChromeOptCapabilities cOpts = new ChromeOptCapabilities(caps);
//        ChromeOptUtils.mergeDesktopBinaryFromCapabilities(cbgCaps, cOpts);
//
//        assertNotEquals(getChromeDriverBinaryFullPath(testPath), cOpts.getBinaryPath());
//        assertEquals(existingPath, cOpts.getBinaryPath());
//
//        cOpts.getFullCapabilities(caps);
//
//        Map<String, Object> decodedCOpts;
//        decodedCOpts = (Map) caps.get(cOptsKey);
//
//        assertNotEquals(getChromeDriverBinaryFullPath(testPath), decodedCOpts.get(cOptsBinaryKey));
//        assertEquals(existingPath, decodedCOpts.get(cOptsBinaryKey));
//    }
//
//    @Test
//    public void emptyBinaryInChromeCapabilities() {
//        TreeMap<String, Object> caps = DesktopCapabilitiesTest.createDesktopCaps(testURL, testPath);
//        LinkedHashMap<String, Object> cBinOpts = new LinkedHashMap<String, Object>();
//        cBinOpts.put(cOptsBinaryKey, ""); // Add an empty binary to the hash
//        caps.put(cOptsKey, cBinOpts); // Insert chromeOpts with a binary
//
//        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
//        Map<String, Object> newCaps;
//
//        ChromeOptCapabilities cOpts = new ChromeOptCapabilities(caps);
//
//        ChromeOptUtils.mergeDesktopBinaryFromCapabilities(cbgCaps, cOpts);
//        cOpts.getFullCapabilities(caps);
//
//        Map<String, Object> decodedCOpts;
//        decodedCOpts = (Map) caps.get(cOptsKey);
//
//        assertEquals(getChromeDriverBinaryFullPath(testPath), decodedCOpts.get(cOptsBinaryKey));
//    }
//
//    @Test
//    public void emptyBinaryInDesktopCaps() {
//        TreeMap<String, Object> caps = DesktopCapabilitiesTest.createDesktopCaps(testURL, "");
//        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
//
//        ChromeOptCapabilities cOpts = new ChromeOptCapabilities(caps);
//
//        assertNull(cOpts.getBinaryPath());
//
//        ChromeOptUtils.mergeDesktopBinaryFromCapabilities(cbgCaps, cOpts);
//
//        Map<String, Object> decodedCOpts;
//        decodedCOpts = cOpts.getChromeOptions();
//        System.out.println(decodedCOpts);
//
//        assertFalse(decodedCOpts.containsKey(cOptsBinaryKey));
//    }
//
//    @Test
//    // If a null cbgcaps object is passed to the merge method, it should not raise an exception
//    public void testNullCBGCaps() {
//        TreeMap<String, Object> caps = new TreeMap<String, Object>();
//        LinkedHashMap<String, Object> cOptsRaw = new LinkedHashMap<String, Object>();
//        cOptsRaw.put(cOptsBinaryKey, getChromeDriverBinaryFullPath(testPath));
//        caps.put(cOptsKey, cOptsRaw);
//        ChromeOptCapabilities cOpts = new ChromeOptCapabilities(caps);
//
//        ChromeOptUtils.mergeDesktopBinaryFromCapabilities(null, cOpts);
//
//        Map<String, Object> cOptsOutputtedRaw = cOpts.getChromeOptions();
//        assertTrue(cOpts.getChromeOptions().containsKey(cOptsBinaryKey));
//        assertEquals(getChromeDriverBinaryFullPath(testPath), cOptsOutputtedRaw.get(cOptsBinaryKey));
//    }
//
//    // Provides chrome options to append to the capabilities
//    public LinkedHashMap<String, Object> mockChromeOptions() {
//        LinkedHashMap<String, Object> existingChromeOpts = new LinkedHashMap<String, Object>();
//        existingChromeOpts.put(mockChromeArgument().get("name"), mockChromeArgument().get("value"));
//        return existingChromeOpts;
//    }
//
//    // Provides chrome options to append to the capabilities
//    public LinkedHashMap<String, String> mockChromeArgument() {
//        LinkedHashMap<String, String> arg = new LinkedHashMap<String, String>();
//        arg.put("name", "debuggerAddress");
//        arg.put("value", "127.0.0.1:38947");
//        return arg;
//    }
//
//    public LinkedHashMap<String, String> mockChromeBinary() {
//        LinkedHashMap<String, String> cBin = new LinkedHashMap<String, String>();
//        cBin.put(cOptsBinaryKey, "C:\\Already\\Exists");
//        return cBin;
//    }
//
//    private String getChromeDriverBinaryFullPath(String relativePath) {
//        return String.format("%s\\%s", desktopAppStorageFolder, relativePath);
//    }
//}
