package com.cbg.selenium.objects;

import static org.junit.Assert.*;
import java.util.TreeMap;

import com.cbg.selenium.capabilities.DesktopCapabilities;
import org.junit.Test;

public class cbgCapabilitiesTest {

    @Test
    public void testNoCBGCaps() {
        TreeMap<String, Object> caps = new TreeMap<String, Object>();
        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
        assertTrue(cbgCaps.empty());
    }

    @Test
    public void testCBGCapsNoDesktop() {
        TreeMap<String, Object> caps = new TreeMap<String, Object>();
        TreeMap<String, Object> cbgCapsInput = new TreeMap<String, Object>();
        caps.put("cbg", cbgCapsInput);

        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
        assertFalse(cbgCaps.empty());
        assertTrue(cbgCaps.getDesktopCapabilities().empty());
    }

//    @Test
//    public void testCBGCapsCaseSensitivity() {
//        TreeMap<String, Object> cbgCapsInput = new TreeMap<String, Object>();
//        TreeMap<String, Object> capsDowncase = new TreeMap<String, Object>();
//        capsDowncase.put("cbg", cbgCapsInput);
//        assertFalse(new CBGCapabilities(capsDowncase).empty());
//
//        TreeMap<String, Object> capsUpcase = new TreeMap<String, Object>();
//        capsUpcase.put("CBG", cbgCapsInput);
//        assertFalse(new CBGCapabilities(capsUpcase).empty());
//
//        TreeMap<String, Object> capsMixedCase = new TreeMap<String, Object>();
//        capsMixedCase.put("cBg", cbgCapsInput);
//        assertFalse(new CBGCapabilities(capsMixedCase).empty());
//    }

    @Test
    public void testCBGCapsWithDesktop() {
        TreeMap<String, Object> caps = new TreeMap<String, Object>();
        TreeMap<String, Object> cbgCapsInput = new TreeMap<String, Object>();
        TreeMap<String, Object> desktopCapsInput = new TreeMap<String, Object>();

        // Build DesktopCaps
        desktopCapsInput.put("artifactURL", "http://www.test.com");
        desktopCapsInput.put("binaryRelativePath", "C:\\Test");

        // Build CBG Caps
        cbgCapsInput.put("desktopApp", desktopCapsInput);
        caps.put("cbg", cbgCapsInput); // Place CBG Caps into the full Selenium Capabilities

        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
        assertFalse(cbgCaps.empty()); // Should not be empty
        assertFalse(cbgCaps.getDesktopCapabilities().empty()); // Should not be empty
        assertTrue(cbgCaps.getDesktopCapabilities() instanceof DesktopCapabilities); // CBGCaps should return a DesktopCapability
    }

    public static TreeMap<String, Object> getCBGCapabilitiesNoDesktop() {
        TreeMap<String, Object> caps = new TreeMap<String, Object>();
        TreeMap<String, Object> cbgCapsInput = new TreeMap<String, Object>();
        caps.put("cbg", cbgCapsInput); // Place CBG Caps into the full Selenium Capabilities

        return caps;
    }
}
