package com.cbg.selenium.proxy;

import com.cbg.selenium.objects.CBGCapabilities;
import org.junit.Test;

import static org.junit.Assert.*;
import java.util.HashMap;

public class CBGRemoteProxyTest {

    @Test
    public void testrequestIsADesktopAppTest() {
        /*
        Without the desktop app caps should return false
         */

        // Create the cbg caps
        HashMap<String, Object> cbgRawCaps = new HashMap<String, Object>();
        HashMap<String, Object> caps = new HashMap<String, Object>();
        caps.put("cbg", cbgRawCaps);

        // Create the object
        CBGCapabilities cbgCaps = new CBGCapabilities(caps);
        assertFalse(CBGRemoteProxy.requestIsADesktopAppTest(cbgCaps));

        /*
        With the desktop app caps should return true
         */

        // Create the desktop caps
        HashMap<String, Object> desktopCaps = new HashMap<String, Object>();
        desktopCaps.put("artifactURL", "http://test.com");
        desktopCaps.put("binaryRelativePath", "path\\to\\bin");

        // Append it into the cbg caps
        cbgRawCaps = new HashMap<String, Object>();
        cbgRawCaps.put("desktopApp", desktopCaps);
        caps = new HashMap<String, Object>();
        caps.put("cbg", cbgRawCaps);

        // Create the object
        cbgCaps = new CBGCapabilities(caps);
        assertTrue(CBGRemoteProxy.requestIsADesktopAppTest(cbgCaps));
    }
}
