module "configuration_template_cdp" {
  source = "../../modules/cluster/hub/config"
  cbg_run_companion        = "false" // TODO - Remove, this is just for the testing stage
  cbg_companion_router_url = "https://api-prod-cdp.browsergrid.xarth.tv"
  environment              = "prod-cdp"
  subnets                  = "${var.subnets}"
  vpc_id                   = "${var.vpc_id}"
  application_name         = "${module.base.hub_application_name}"
  instance_profile_arn     = "${module.base.hub_instance_profile_name}"
  elb_managed_security_group = "${module.base.hub_elb_sg}"
  elb_security_groups      = ["${module.base.hub_elb_sg}"]
  instance_security_groups = ["${module.base.hub_instance_sg}"]
  se_major_version         = "4"
  load_balancer_type       = "network"
  enable_se4_listeners     = "true"
}

module "cdp_1" {
  source = "../../modules/cluster"
  environment                     = "prod-cdp"
  node_environment                = "prod"
  node_subnets                    = "${var.subnets}"
  vpc_id                          = "${var.vpc_id}"
  node_instance_type              = "c4.xlarge"
  node_count                      = "1"
  node_instance_profile_name      = "${module.base.node_instance_profile_name}"
  node_sns_arn_low                = "${module.base.node_sns_arn_low}"
  node_sns_arn_high               = "${module.base.node_sns_arn_high}"
  node_asg_suspended_processes    = ["AZRebalance", "HealthCheck"]
  hub_configuration_template_name = "${module.configuration_template_cdp.name}"
  hub_application_name            = "${module.base.hub_application_name}"
  hub_elb_managed_security_group  = "${module.base.hub_elb_sg}"
  hub_sns_arn                     = "${module.base.hub_sns_arn}"
  hub_env_health_threshold        = "${var.hub_env_health_threshold}"
  cw_es_shipper_lambda_name       = "${module.base.cw_es_shipper_lambda_function_name}"
  node_security_groups            = ["${module.base.node_instance_sg}"]
  se_major_version                = "4"
  alarms_enabled                  = false
  enable_hub_vpc_endpoint         = false // custom VPC Endpoint because this uses a NLB Already.
}

// Create the VPC Endpoint
resource "aws_vpc_endpoint_service" "cdp_1_private_link" {
  network_load_balancer_arns = ["${module.cdp_1.hub_loadbalancer}"]
  acceptance_required        = true
  allowed_principals         = ["*"]

  lifecycle {
    prevent_destroy = true
  }

  tags = {
    Name                                = "${module.cdp_1.hub_name}"
    "elasticbeanstalk:environment-name" = "${module.cdp_1.hub_name}"
  }
}
