// Used for PagerDuty Alerts
resource "aws_sns_topic" "alerts" {
  name = "browsergrid-prod-alerts"
}

# Subscribe SNS Topic to PagerDuty
# Allows Incidents to be triaged to PagerDuty
# https://twitchoncall.pagerduty.com/services/PAOXLE9
resource "aws_sns_topic_subscription" "pagerduty" {
  topic_arn = "${aws_sns_topic.alerts.arn}"
  protocol  = "https"
  endpoint  = "https://events.pagerduty.com/integration/022064b4cdea454680a33c1b99280bf0/enqueue"
  endpoint_auto_confirms = true
}
