module "configuration_template" {
  source = "../../modules/cluster/hub/config"
  cbg_companion_router_url = "${var.cbg_companion_router_url}"
  environment                = "${var.environment}"
  subnets                    = "${var.subnets}"
  vpc_id                     = "${var.vpc_id}"
  application_name           = "${module.base.hub_application_name}"
  instance_profile_arn       = "${module.base.hub_instance_profile_name}"
  elb_managed_security_group = "${module.base.hub_elb_sg}"
  elb_security_groups        = ["${module.base.hub_elb_sg}"]
  instance_security_groups   = ["${module.base.hub_instance_sg}"]
}

module "prod_1" {
  source = "../../modules/cluster"
  environment                     = "${var.environment}"
  node_environment                = "${var.node_environment}"
  node_subnets                    = "${var.subnets}"
  vpc_id                          = "${var.vpc_id}"
  node_instance_type              = "c4.xlarge"
  node_count                      = "18"
  node_instance_profile_name      = "${module.base.node_instance_profile_name}"
  node_sns_arn_low                = "${module.base.node_sns_arn_low}"
  node_sns_arn_high               = "${module.base.node_sns_arn_high}"
  node_asg_suspended_processes    = ["AZRebalance", "HealthCheck"]
  hub_configuration_template_name = "${module.configuration_template.name}"
  hub_application_name            = "${module.base.hub_application_name}"
  hub_elb_managed_security_group  = "${module.base.hub_elb_sg}"
  hub_sns_arn                     = "${module.base.hub_sns_arn}"
  hub_env_health_threshold        = "${var.hub_env_health_threshold}"
  cw_es_shipper_lambda_name       = "${module.base.cw_es_shipper_lambda_function_name}"
  node_security_groups            = ["${module.base.node_instance_sg}"]
}
