variable "environment" {
  default = "prod"
}

variable "cbg_companion_router_url" {
  default = "https://api-prod.browsergrid.xarth.tv"
}

variable "cbg_companion_router_url_2xl" {
  default = "https://api-prod-2xl.browsergrid.xarth.tv"
}

variable "subnets" {
  type = "list"
  default = [
    "subnet-0aeab8564c4d6c313", // Private A
    "subnet-0ca1c3bda01107265", // Private B
    "subnet-0bf7cdf285dc3893e" // Private C
  ]
}

variable "vpc_id" {
  default = "vpc-05035011a23d81f23"
}

variable "node_environment" {
  default = "prod"
}

/*
The threshold of the Hub Beanstalk Environment at which it alarms
0 (Ok), 1 (Info), 5 (Unknown), 10 (No data), 15 (Warning), 20 (Degraded), 25 (Severe)
*/
variable "hub_env_health_threshold" {
  default = "20"
}
