module "configuration_template" {
  source = "../../../../modules/cluster/hub/config"
  cbg_companion_router_url = "${var.cbg_companion_router_url}"
  environment              = "${var.environment}"
  subnets                  = "${var.hub_subnet}"
  vpc_id                   = "${var.vpc_id}"
  application_name         = "${data.terraform_remote_state.base.hub_application_name}"
  instance_profile_arn     = "${data.terraform_remote_state.base.hub_instance_profile_name}"
  cbg_trigger_pd_events    = "false"
  instance_type            = "t3.micro"
  elb_managed_security_group = "${data.terraform_remote_state.base.hub_elb_sg}"
  elb_security_groups      = ["${data.terraform_remote_state.base.hub_elb_sg}",
                              "${data.aws_security_group.twitch_subnets.id}"]
  instance_security_groups = ["${data.aws_security_group.twitch_ssh.id}",
                              "${data.terraform_remote_state.base.hub_instance_sg}"]
}
