module "1_dev" {
  source = "../../../../modules/cluster"
  hub_configuration_template_name = "${module.configuration_template.name}"
  environment = "${var.environment}"
  node_environment = "${var.node_environment}"
  node_subnets = "${var.node_subnets}"
  vpc_id       = "${var.vpc_id}"
  hub_env_health_threshold = "${var.hub_env_health_threshold}"
  node_asg_suspended_processes = ["HealthCheck"] // suspend healthcheck, allow node to be shut down and not replaced
  node_count = "2"
  cw_es_shipper_lambda_name  = "${data.terraform_remote_state.base.cw_es_shipper_lambda_function_name}"
  hub_application_name       = "${data.terraform_remote_state.base.hub_application_name}"
  node_instance_profile_name = "${data.terraform_remote_state.base.node_instance_profile_name}"
  hub_sns_arn                = "${data.terraform_remote_state.base.hub_sns_arn}"
  node_sns_arn_low           = "${data.terraform_remote_state.base.node_sns_arn_low}"
  node_sns_arn_high          = "${data.terraform_remote_state.base.node_sns_arn_high}"
  node_security_groups       = ["${data.aws_security_group.twitch_subnets.id}",
                                "${data.terraform_remote_state.base.node_instance_sg}"]
  enable_hub_vpc_endpoint    = false // Grid Router exists within this account. No need to connect via VPCE
  alarms_enabled             = false
}
