data "terraform_remote_state" "base" {
  backend = "s3"
  config {
    profile = "twitch-cape-qe-aws"
    bucket = "tf-state-qe"
    key    = "tfstate/qe/grid/terraform/accounts/twitch-cape-qe-aws/hub"
    region = "us-west-2"
  }
}

data "aws_security_group" "twitch_ssh" {
  filter {
    name = "group-name"
    values = ["allow_ssh_from_twitch_subnets"]
  }
}

data "aws_security_group" "twitch_subnets" {
  filter {
    name = "group-name"
    values = ["twitch_subnets"]
  }
}
