module "base" {
  source = "../../modules/base"
  vpc_id = "${var.vpc_id}"
  enable_grid_router_vpce = false // Grid Router runs in this account. No need to establish a VPC Endpoint with it
}

output "hub_application_name" {
  value = "${module.base.hub_application_name}"
}

output "hub_iam_role_arn" {
  value = "${module.base.hub_iam_role_arn}"
}

output "hub_instance_profile_name" {
  value = "${module.base.hub_instance_profile_name}"
}

output "node_iam_role_arn" {
  value = "${module.base.node_iam_role_arn}"
}

output "node_instance_profile_name" {
  value = "${module.base.node_instance_profile_name}"
}

output "hub_sns_arn" {
  value = "${module.base.hub_sns_arn}"
}

output "node_sns_arn_high" {
  value = "${module.base.node_sns_arn_high}"
}

output "node_sns_arn_low" {
  value = "${module.base.node_sns_arn_low}"
}

output "cw_es_shipper_lambda_function_name" {
  value = "${module.base.cw_es_shipper_lambda_function_name}"
}

output "node_instance_sg" {
  value = "${module.base.node_instance_sg}"
}

output "hub_instance_sg" {
  value = "${module.base.hub_instance_sg}"
}

output "hub_elb_sg" {
  value = "${module.base.hub_elb_sg}"
}
