# Contains configuration (S3 & IAM) for Grid VM Import

variable "bucket_name" {
  default = "grid-vm-import"
}

resource "aws_s3_bucket" "import-bucket-us-west-2" {
  bucket = "${var.bucket_name}-us-west-2"
  acl    = "private"

  tags {
    Name = "${var.bucket_name} us-west-2"
  }
}

resource "aws_iam_role" "vmimport" {
  name = "vmimport"

  assume_role_policy = <<EOF
{
   "Version": "2012-10-17",
   "Statement": [
      {
         "Effect": "Allow",
         "Principal": { "Service": "vmie.amazonaws.com" },
         "Action": "sts:AssumeRole",
         "Condition": {
            "StringEquals":{
               "sts:Externalid": "vmimport"
            }
         }
      }
   ]
}
EOF
}

resource "aws_iam_role_policy" "vmimport-policy-us-west-2" {
  name = "vmimport-policy-us-west-2"
  role = "${aws_iam_role.vmimport.id}"

  policy = <<EOF
{
   "Version":"2012-10-17",
   "Statement":[
      {
         "Effect":"Allow",
         "Action":[
            "s3:GetBucketLocation",
            "s3:GetObject",
            "s3:ListBucket"
         ],
         "Resource":[
            "arn:aws:s3:::${aws_s3_bucket.import-bucket-us-west-2.bucket}",
            "arn:aws:s3:::${aws_s3_bucket.import-bucket-us-west-2.bucket}/*"
         ]
      },
      {
         "Effect":"Allow",
         "Action":[
            "ec2:ModifySnapshotAttribute",
            "ec2:CopySnapshot",
            "ec2:RegisterImage",
            "ec2:Describe*"
         ],
         "Resource":"*"
      }
   ]
}
EOF
}
