# Sets up the SSM Document Resources to make a Chef Deployment within the account

# Script that will update the chef artifact bundle on the machine
data "local_file" "update_chef_artifacts" {
  filename = "${path.module}/scripts/update_chef_artifacts.ps1"
}

# Script that will trigger Chef to run
data "local_file" "run_chef" {
  filename = "${path.module}/scripts/run_chef.ps1"
}

resource "aws_ssm_document" "chef_update_run" {
  name          = "Update_And_Run_Chef_Solo"
  document_type = "Command"

  content = <<DOC
  {
    "schemaVersion": "2.2",
    "description": "Downloads latest Chef Artifacts and runs Chef Solo",
    "parameters": {
      "branch": {
         "type": "String",
         "description": "The branch to deploy to the node",
         "default": "master"
      }
    },
    "mainSteps": [
      {
        "action": "aws:runPowerShellScript",
        "name": "Update_Artifacts",
        "inputs": {
          "runCommand": [ ${jsonencode(data.local_file.update_chef_artifacts.content)} ]
        }
      },
      {
        "action": "aws:runPowerShellScript",
        "name": "Run_Chef",
        "inputs": {
          "runCommand": [ ${jsonencode(data.local_file.run_chef.content)} ]
        }
      }
    ]
  }
DOC
}
