# Set up Cloudwatch Log Groups for Security Offhost Logging

variable "security_log_retention" {
  default = 365
}

# Used for logs not critical for security
variable "normal_log_retention" {
  default = 180 // 6 months
}

resource "aws_cloudwatch_log_group" "system" {
  name = "/aws/ec2/grid/win10/system"
  retention_in_days = "${var.security_log_retention}"

  tags = {
    Service = "Grid"
    Owner = "reichsta"
  }
}

resource "aws_cloudwatch_log_group" "security" {
  name = "/aws/ec2/grid/win10/security"
  retention_in_days = "${var.security_log_retention}"

  tags = {
    Service = "Grid"
    Owner = "reichsta"
  }
}

resource "aws_cloudwatch_log_group" "sysmon" {
  name = "/aws/ec2/grid/win10/sysmon"
  retention_in_days = "${var.security_log_retention}"

  tags = {
    Service = "Grid"
    Owner = "reichsta"
  }
}

resource "aws_cloudwatch_log_group" "nginx" {
  name = "/aws/ec2/grid/win10/nginx"
  retention_in_days = "${var.security_log_retention}"

  tags = {
    Service = "Grid"
    Owner = "reichsta"
  }
}

resource "aws_cloudwatch_log_group" "selenium" {
  name = "/aws/ec2/grid/win10/selenium"
  retention_in_days = "${var.normal_log_retention}"

  tags = {
    Service = "Grid"
    Owner = "reichsta"
  }
}

resource "aws_cloudwatch_log_group" "provisioner" {
  name = "/aws/ec2/grid/win10/provisioner"
  retention_in_days = "${var.normal_log_retention}"

  tags = {
    Service = "Grid"
    Owner = "reichsta"
  }
}

resource "aws_cloudwatch_log_group" "launcher" {
  name = "/aws/ec2/grid/win10/launcher"
  retention_in_days = "${var.normal_log_retention}"

  tags = {
    Service = "Grid"
    Owner = "reichsta"
  }
}

resource "aws_cloudwatch_log_group" "geckodriver" {
  name = "/aws/ec2/grid/win10/geckodriver"
  retention_in_days = "${var.normal_log_retention}"

  tags = {
    Service = "Grid"
    Owner = "reichsta"
  }
}

resource "aws_cloudwatch_log_group" "selenium_output" {
  name = "/aws/ec2/grid/win10/selenium_output"
  retention_in_days = "${var.normal_log_retention}"

  tags = {
    Service = "Grid"
    Owner = "reichsta"
  }
}

resource "aws_cloudwatch_log_group" "selenium_output_error" {
  name = "/aws/ec2/grid/win10/selenium_output_error"
  retention_in_days = "${var.normal_log_retention}"

  tags = {
    Service = "Grid"
    Owner = "reichsta"
  }
}
