// Creates base resources for Selenium Hub to be used for a New Account

// Base Application to put all Hubs into
resource "aws_elastic_beanstalk_application" "hub" {
  name        = "grid-hub"
  description = "Cross Browser Grid Hub"

  appversion_lifecycle {
    service_role          = "${aws_iam_role.GridEBServiceRole.arn}"
    max_count             = 100
    delete_source_from_s3 = true
  }
}

resource "aws_iam_role" "hub" {
  name = "grid_hub"

  assume_role_policy = <<-EOF
  {
    "Version": "2012-10-17",
    "Statement": [
      {
        "Sid": "",
        "Effect": "Allow",
        "Principal": {
          "Service": "ec2.amazonaws.com"
        },
        "Action": "sts:AssumeRole"
      }
    ]
  }
  EOF
}

resource "aws_iam_instance_profile" "hub" {
  name = "grid_hub"
  role = "${aws_iam_role.hub.name}"
}

# Add a cloudwatch policy for mon-scripts to post to CloudWatch
# https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/mon-scripts.html
resource "aws_iam_policy" "cloudwatch_logs" {
  name        = "grid_hub_cloudwatch_logs"
  path        = "/"
  description = "A policy for writing instance data (memory utilization, etc) to CloudWatch"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "Stmt1535734359418",
      "Action": [
        "cloudwatch:GetMetricStatistics",
        "cloudwatch:ListMetrics",
        "cloudwatch:PutMetricData"
      ],
      "Effect": "Allow",
      "Resource": "*"
    },
    {
      "Sid": "Stmt1535734422775",
      "Action": [
        "ec2:DescribeTags"
      ],
      "Effect": "Allow",
      "Resource": "*"
    }
  ]
}
EOF
}

# Attach the policy to the role
resource "aws_iam_role_policy_attachment" "cloudwatch_attach" {
  role       = "${aws_iam_role.hub.name}"
  policy_arn = "${aws_iam_policy.cloudwatch_logs.arn}"
}

resource "aws_iam_role_policy_attachment" "beanstalk_read_only" {
  role = "${aws_iam_role.hub.name}"
  policy_arn = "arn:aws:iam::aws:policy/AWSElasticBeanstalkReadOnly"
}

resource "aws_iam_role_policy_attachment" "cw_agent_server_policy" {
  role = "${aws_iam_role.hub.name}"
  policy_arn = "arn:aws:iam::aws:policy/CloudWatchAgentServerPolicy"
}

# Allow AWS SSM Access
resource "aws_iam_role_policy_attachment" "ssm_hub" {
  role       = "${aws_iam_role.hub.name}"
  policy_arn = "arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore"
}
