// Creates base resources for Shipping Cloudwatch Logs to ES

data "terraform_remote_state" "elasticsearch" {
  backend = "s3"
  config {
    profile = "twitch-browsergrid-prod"
    bucket  = "twitch-browsergrid-prod-us-west-2"
    key     = "tfstate/qe/grid/terraform/accounts/twitch-browsergrid-prod/central_infrastructure"
    region  = "us-west-2"
  }
}

module "cw_es_shipper" {
  source = "git::git+ssh://git@git.xarth.tv/qe/cw_es_shipper//terraform/modules/lambda?ref=1.1.0"
  elasticsearch_endpoint_url = "https://${data.terraform_remote_state.elasticsearch.elasticsearch_domain_endpoint}"
  elasticsearch_arn          = "${data.terraform_remote_state.elasticsearch.elasticsearch_domain_arn}"
}

// Add a subscription to Windows Log Groups
module "launcher_subscription" {
  source = "git::git+ssh://git@git.xarth.tv/qe/cw_es_shipper//terraform/modules/cw_logs_subscription?ref=1.0.0"
  cloudwatch_log_group_name = "${aws_cloudwatch_log_group.launcher.name}"
  lambda_name               = "${module.cw_es_shipper.aws_lambda_function_name}"
}

// Node Provisioning
module "provisioner_subscription" {
  source = "git::git+ssh://git@git.xarth.tv/qe/cw_es_shipper//terraform/modules/cw_logs_subscription?ref=1.0.0"
  cloudwatch_log_group_name = "${aws_cloudwatch_log_group.provisioner.name}"
  lambda_name               = "${module.cw_es_shipper.aws_lambda_function_name}"
}

// Selenium Logs
module "selenium_subscription" {
  source = "git::git+ssh://git@git.xarth.tv/qe/cw_es_shipper//terraform/modules/cw_logs_subscription?ref=1.0.0"
  cloudwatch_log_group_name = "${aws_cloudwatch_log_group.selenium.name}"
  lambda_name               = "${module.cw_es_shipper.aws_lambda_function_name}"
}

module "geckodriver_subscription" {
  source = "git::git+ssh://git@git.xarth.tv/qe/cw_es_shipper//terraform/modules/cw_logs_subscription?ref=1.0.0"
  cloudwatch_log_group_name = "${aws_cloudwatch_log_group.geckodriver.name}"
  lambda_name               = "${module.cw_es_shipper.aws_lambda_function_name}"
}

module "selenium_output_subscription" {
  source = "git::git+ssh://git@git.xarth.tv/qe/cw_es_shipper//terraform/modules/cw_logs_subscription?ref=1.0.0"
  cloudwatch_log_group_name = "${aws_cloudwatch_log_group.selenium_output.name}"
  lambda_name               = "${module.cw_es_shipper.aws_lambda_function_name}"
}

module "selenium_output_error_subscription" {
  source = "git::git+ssh://git@git.xarth.tv/qe/cw_es_shipper//terraform/modules/cw_logs_subscription?ref=1.0.0"
  cloudwatch_log_group_name = "${aws_cloudwatch_log_group.selenium_output_error.name}"
  lambda_name               = "${module.cw_es_shipper.aws_lambda_function_name}"
}

output "cw_es_shipper_lambda_function_name" {
  value = "${module.cw_es_shipper.aws_lambda_function_name}"
}
