// Creates base resources for Selenium Nodes to be used for a New Account

resource "aws_iam_role" "node" {
  name = "selenium-grid"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "node" {
  name  = "selenium-grid"
  role = "${aws_iam_role.node.name}"
}

resource "aws_iam_role_policy_attachment" "ssm" {
  role = "${aws_iam_role.node.name}"
  policy_arn = "arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore"
}

// Add a role for read only on EC2 - Used for things like querying own tags
resource "aws_iam_role_policy_attachment" "ec2" {
  role = "${aws_iam_role.node.name}"
  policy_arn = "arn:aws:iam::aws:policy/AmazonEC2ReadOnlyAccess"
}

// Add a role to allow uploading cloudwatch metrics
resource "aws_iam_role_policy_attachment" "cw_agent_server" {
  role = "${aws_iam_role.node.name}"
  policy_arn = "arn:aws:iam::aws:policy/CloudWatchAgentServerPolicy"
}

// Attach a policy for Sandstorm to be able to access. Used for node credential
resource "aws_iam_role_policy" "sandstorm" {
  name = "sandstorm-grid"
  role = "${aws_iam_role.node.id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Resource": [
        "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/qe-prod-grid"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

# Allow access to the S3 Artifact Bucket
resource "aws_iam_policy" "artifact_access" {
  name = "Grid-Artifact-Access"
  description = "Gives nodes permission to download Grid Artifacts"
  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "s3:GetObject"
            ],
            "Resource": [
                "arn:aws:s3:::grid-artifacts/*",
                "arn:aws:s3:::grid-artifacts"
            ]
        }
    ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "artifact_access" {
  role = "${aws_iam_role.node.name}"
  policy_arn = "${aws_iam_policy.artifact_access.arn}"
}

# Allow publishing to Cloudwatch Logs
resource "aws_iam_role_policy" "cwl_write" {
  name = "cloudwatch_log_upload"
  role = "${aws_iam_role.node.id}"
  policy = <<-EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "Stmt1607727570081",
      "Action": [
        "logs:CreateLogGroup",
        "logs:CreateLogStream",
        "logs:PutLogEvents"
      ],
      "Effect": "Allow",
      "Resource": "*"
    }
  ]
}
  EOF
}
