data "aws_region" "current" {}
data "aws_caller_identity" "current" {}

data "aws_vpc" "vpc" {
  id = "${var.vpc_id}"
}

data "aws_subnet" "private_a" {
  filter {
    name   = "tag:Name"
    values = ["Private - A"]
  }
}

data "aws_subnet" "private_b" {
  filter {
    name   = "tag:Name"
    values = ["Private - B"]
  }
}

data "aws_subnet" "private_c" {
  filter {
    name   = "tag:Name"
    values = ["Private - C"]
  }
}

data "aws_security_group" "default" {
  vpc_id = "${var.vpc_id}"
  filter {
    name = "group-name"
    values = ["default"]
  }
}

data "aws_vpc_endpoint_service" "grid_router_dev" {
  count    = "${var.enable_grid_router_vpce ? 1 : 0}"
  provider = "aws.twitch-cape-qe-aws"
  filter {
    name   = "tag:Name"
    values = ["grid-router-dev"]
  }
}

data "aws_vpc_endpoint_service" "grid_router_dev_ato" {
  count    = "${var.enable_grid_router_dev_vpce ? 1 : 0}"
  provider = "aws.twitch-cape-qe-aws"
  filter {
    name   = "tag:Name"
    values = ["grid-router-dev-ato"]
  }
}

data "aws_vpc_endpoint_service" "grid_router_prod" {
  count    = "${var.enable_grid_router_vpce ? 1 : 0}"
  provider = "aws.twitch-cape-qe-aws"
  filter {
    name   = "tag:Name"
    values = ["grid-router-prod"]
  }
}

data "aws_vpc_endpoint_service" "grid_router_prod_2xl" {
  count    = "${var.enable_grid_router_vpce ? 1 : 0}"
  provider = "aws.twitch-cape-qe-aws"
  filter {
    name   = "tag:Name"
    values = ["grid-router-prod-2xl"]
  }
}

data "aws_iam_policy" "AWSElasticBeanstalkService" {
  arn = "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkService"
}
