$ErrorActionPreference = "Stop"

$config_directory = "C:\ProgramData\grid-config"
$s3_artifact_bucket = "grid-artifacts"

# Fetch the Git Branch from the SSM Document Template
$git_branch_name = "{{branch}}"

# Download the Chef Artifacts
echo "Downloading Chef Artifacts from branch: $git_branch_name"
$chef_artifacts_file = "chef_artifacts.zip"
Read-S3Object -BucketName "$s3_artifact_bucket" -File "$config_directory\$chef_artifacts_file" -Key "git/$git_branch_name/$chef_artifacts_file"

# Remove Old
Remove-Item -Recurse -Path "$config_directory\chef"

New-Item -type directory "$config_directory\chef" # Create the directory
Expand-Archive -Path "$config_directory/$chef_artifacts_file" -DestinationPath "$config_directory\chef"
Remove-Item -Path "$config_directory\$chef_artifacts_file" # Clean Up
