resource "aws_security_group" "node" {
  name        = "GridWin10NodeInstances"
  description = "Security Group for Browser Grid Nodes"
  vpc_id      = "${var.vpc_id}"

  ingress {
    description = "Connections from Hub"
    from_port   = 80
    to_port     = 80
    protocol    = "tcp"
    security_groups = ["${aws_security_group.hub_instances.id}"]
  }

  ingress { // allow communication across other instances using this SG. Used for VPC Endpoint Comms
    from_port = 0
    protocol  = "-1"
    to_port   = 0
    self      = true
  }

  // Selenium 4.0 Specific Ports
  ingress {
    description = "Connections from Hub (Selenium 4.0)"
    from_port   = 4442
    to_port     = 4442
    protocol    = "tcp"
    security_groups = ["${aws_security_group.hub_instances.id}"]
  }

  ingress {
    description = "Connections from Hub (Selenium 4.0)"
    from_port   = 4443
    to_port     = 4443
    protocol    = "tcp"
    security_groups = ["${aws_security_group.hub_instances.id}"]
  }

  ingress { // TODO - remove when DELIVERY-2797 is addressed
    description = "Connections from Hub (Selenium 4.0)"
    from_port   = 5555
    to_port     = 5555
    protocol    = "tcp"
    security_groups = ["${aws_security_group.hub_instances.id}"]
  }

  egress {
    description = "Allow all outbound"
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }
}

resource "aws_security_group" "hub_elb" {
  name        = "GridHubELB"
  description = "Security Group for Browser Grid Hub ELB"
  vpc_id      = "${var.vpc_id}"
}

resource "aws_security_group_rule" "hub_elb_node_instances" { // Using this to prevent circular dependencies
  security_group_id = "${aws_security_group.hub_elb.id}"
  type        = "ingress"
  description = "Connections from Node Instances"
  protocol    = "tcp"
  from_port   = 80
  to_port     = 80
  source_security_group_id = "${aws_security_group.node.id}"
}

resource "aws_security_group_rule" "hub_elb_hub_instances" { // Using this to prevent circular dependencies
  security_group_id = "${aws_security_group.hub_elb.id}"
  type        = "egress"
  description = "Connections to Hub Backend Instances"
  protocol    = "tcp"
  from_port   = 80
  to_port     = 80
  source_security_group_id = "${aws_security_group.hub_instances.id}"
}

resource "aws_security_group" "hub_instances" {
  name        = "GridHubBackendInstances"
  description = "Security Group for Browser Grid Hub Instances"
  vpc_id      = "${var.vpc_id}"

  ingress {
    description = "Allow from ELB"
    protocol    = "tcp"
    from_port   = 80
    to_port     = 80
    security_groups = ["${aws_security_group.hub_elb.id}"]
  }

  ingress { // allow communication across other instances using this SG. Used for VPC Endpoint Comms
    from_port = 0
    protocol  = "-1"
    to_port   = 0
    self      = true
  }

  egress {
    description = "Allow all outbound"
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }
}
