variable "pd_node_service_high" { // https://twitchoncall.pagerduty.com/services/P9GRQVZ
  default = "https://events.pagerduty.com/integration/2868c9bfb6db4150b50f9a1269164ee9/enqueue"
}

variable "pd_node_service_low" { // https://twitchoncall.pagerduty.com/services/PP76GDN
  default = "https://events.pagerduty.com/integration/d7157df6fc9647799b9034ad88361572/enqueue"
}

variable "pd_hub_service_high" { // https://twitchoncall.pagerduty.com/services/PTR28PR
  default = "https://events.pagerduty.com/integration/8056498b827c49d181e1a47d1dad9988/enqueue"
}

########
# Node #
########

// High Urgency Alerts
resource "aws_sns_topic" "node_high" {
  name = "selenium-grid-high"
}

resource "aws_sns_topic_subscription" "node_high_pagerduty" {
  topic_arn = "${aws_sns_topic.node_high.arn}"
  protocol  = "https"
  endpoint  = "${var.pd_node_service_high}"
  endpoint_auto_confirms = true
}

// Low Urgency Alerts
resource "aws_sns_topic" "node_low" {
  name = "selenium-grid-low"
}

resource "aws_sns_topic_subscription" "node_low_pagerduty" {
  topic_arn = "${aws_sns_topic.node_low.arn}"
  protocol  = "https"
  endpoint  = "${var.pd_node_service_low}"
  endpoint_auto_confirms = true
}

#######
# Hub #
#######
resource "aws_sns_topic" "hub" {
  name = "grid-hub"
}

resource "aws_sns_topic_subscription" "hub_pagerduty" {
  topic_arn = "${aws_sns_topic.hub.arn}"
  protocol  = "https"
  endpoint  = "${var.pd_hub_service_high}"
  endpoint_auto_confirms = true
}

