variable "vpc_id" {
  type = "string"
}

// Boolean to create a VPC Endpoint connection with Grid Router
// do not create this in a VPC Grid Router is already running in
variable "enable_grid_router_vpce" {
  default = true
}

// Boolean to create a VPC Endpoint connection with Grid Router DEVELOPMENT
// This is for the staging Grid Router
variable "enable_grid_router_dev_vpce" {
  default = false
}

// VPC Endpoint Service Name for GraphQL Development
variable "gql_endpoint_dev" {
  default = "com.amazonaws.vpce.us-west-2.vpce-svc-09b7fec2c3aeb0fbd"
}

// VPC Endpoint Service Name for GraphQL Production
variable "gql_endpoint_prod" {
  default = "com.amazonaws.vpce.us-west-2.vpce-svc-05c977702ada7629d"
}

// VPC Endpoint Service Name for Passport Production
variable "passport_endpoint_prod" {
  default = "com.amazonaws.vpce.us-west-2.vpce-svc-08b3dffb6bc2ee157"
}

// VPC Endpoint Service Name for Tempo Production
variable "tempo_endpoint_prod" {
  default = "com.amazonaws.vpce.us-west-2.vpce-svc-038634df5f998f334"
}

// VPC Endpoint Service Name for Artifactory Production
variable "artifactory_endpoint_prod" {
  default = "com.amazonaws.vpce.us-west-2.vpce-svc-0ae1454184d60ff60"
}

// VPC Endpoint Service Name for Sage Staging
variable "sage_endpoint_test_env" {
  default = "com.amazonaws.vpce.us-west-2.vpce-svc-060c98d299e678a8a"
}
