// Creates a VPC Endpoint connection with Artifactory

// Zone to store Production Artifactory Route
// Does not use a top-level xarth.tv so that other xarth records don't route through private zone
resource "aws_route53_zone" "artifactory_prod" {
  name = "pkgs.xarth.tv"
  vpc {
    vpc_id = "${var.vpc_id}"
  }
}

// SG to allow connections to the VPC Endpoint
resource "aws_security_group" "artifactory_vpce" {
  name        = "artifactory_vpce"
  description = "Allow connections to the Artifactory VPC Endpoint"
  vpc_id      = "${var.vpc_id}"

  ingress {
    description = "http"
    from_port   = 80
    to_port     = 80
    protocol    = "tcp"
    self        = true
  }

  ingress {
    description = "https"
    from_port   = 443
    to_port     = 443
    protocol    = "tcp"
    self        = true
  }

  tags = {
    Name = "artifactory_vpce"
  }
}

resource "aws_vpc_endpoint" "artifactory_prod" {
  vpc_id             = "${var.vpc_id}"
  service_name       = "${var.artifactory_endpoint_prod}"
  vpc_endpoint_type  = "Interface"
  security_group_ids = ["${data.aws_security_group.default.id}", "${aws_security_group.hub_instances.id}",
    "${aws_security_group.node.id}", "${aws_security_group.artifactory_vpce.id}"]
  subnet_ids = ["${data.aws_subnet.private_a.id}", "${data.aws_subnet.private_b.id}", "${data.aws_subnet.private_c.id}"]

  tags {
    Name = "artifactory-production"
  }
}

// Redirect requests to Artifactory to the VPC Endpoint
resource "aws_route53_record" "artifactory_prod" {
  name    = ""
  type    = "A"
  zone_id = "${aws_route53_zone.artifactory_prod.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "artifactory_prod_gen" {
  name    = "gen"
  type    = "A"
  zone_id = "${aws_route53_zone.artifactory_prod.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "artifactory_prod_maven" {
  name    = "maven"
  type    = "A"
  zone_id = "${aws_route53_zone.artifactory_prod.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "artifactory_prod_deb" {
  name    = "deb"
  type    = "A"
  zone_id = "${aws_route53_zone.artifactory_prod.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "artifactory_prod_docker" {
  name    = "docker"
  type    = "A"
  zone_id = "${aws_route53_zone.artifactory_prod.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "artifactory_prod_gem" {
  name    = "gem"
  type    = "A"
  zone_id = "${aws_route53_zone.artifactory_prod.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "artifactory_prod_npm" {
  name    = "npm"
  type    = "A"
  zone_id = "${aws_route53_zone.artifactory_prod.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "artifactory_prod_nuget" {
  name    = "nuget"
  type    = "A"
  zone_id = "${aws_route53_zone.artifactory_prod.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "artifactory_prod_pypi" {
  name    = "pypi"
  type    = "A"
  zone_id = "${aws_route53_zone.artifactory_prod.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "artifactory_prod_rpm" {
  name    = "rpm"
  type    = "A"
  zone_id = "${aws_route53_zone.artifactory_prod.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.artifactory_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}
