// Creates a VPC Endpoint connection with GraphQL
// https://jira.twitch.com/browse/IPDEL-1443

// Zone to store Production GQL Route
// Does not use a top-level twitch.a2z.com so that other a2z records don't route through private zone
resource "aws_route53_zone" "gql_prod_xarth" {
  name = "graphql.twitch.a2z.com"
  vpc {
    vpc_id = "${var.vpc_id}"
  }
}

// Zone to store Development GQL Route
// Does not use a top-level twitch.a2z.com so that other a2z records don't route through private zone
resource "aws_route53_zone" "gql_dev_xarth" {
  name = "dev-graphql.twitch.a2z.com"
  vpc {
    vpc_id = "${var.vpc_id}"
  }
}

##################
# GQL Production #
##################

resource "aws_vpc_endpoint" "gql_prod" {
  vpc_id             = "${var.vpc_id}"
  service_name       = "${var.gql_endpoint_prod}"
  vpc_endpoint_type  = "Interface"
  security_group_ids = ["${aws_security_group.node.id}"]
  subnet_ids = ["${data.aws_subnet.private_a.id}", "${data.aws_subnet.private_b.id}", "${data.aws_subnet.private_c.id}"]

  tags {
    Name = "gql-production"
  }
}

// Redirect requests to graphql.twitch.a2z.com to the VPC Endpoint
resource "aws_route53_record" "gql_prod" {
  name    = ""
  type    = "A"
  zone_id = "${aws_route53_zone.gql_prod_xarth.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.gql_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.gql_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}

###################
# GQL Development #
###################

resource "aws_vpc_endpoint" "gql_dev" {
  vpc_id             = "${var.vpc_id}"
  service_name       = "${var.gql_endpoint_dev}"
  vpc_endpoint_type  = "Interface"
  security_group_ids = ["${aws_security_group.node.id}"]
  subnet_ids = ["${data.aws_subnet.private_a.id}", "${data.aws_subnet.private_b.id}", "${data.aws_subnet.private_c.id}"]

  tags {
    Name = "gql-development"
  }
}

// Redirect requests to dev-graphql.twitch.a2z.com to the VPC Endpoint
resource "aws_route53_record" "gql_dev" {
  name    = ""
  type    = "A"
  zone_id = "${aws_route53_zone.gql_dev_xarth.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.gql_dev.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.gql_dev.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}
