// Creates a VPC Endpoint connection with Grid Router

// Zone to store records in that route to the VPC Endpoint
resource "aws_route53_zone" "browsergrid_xarth" {
  count = "${var.enable_grid_router_vpce ? 1 : 0}"
  name = "browsergrid.xarth.tv"
  vpc {
    vpc_id = "${var.vpc_id}"
  }
}

// SG to allow connections to the VPC Endpoint
resource "aws_security_group" "grid_router_vpce" {
  name        = "grid_router_vpce"
  description = "Allow connections to the Grid Router VPC Endpoint"
  vpc_id      = "${var.vpc_id}"

  ingress {
    description = "http"
    from_port   = 80
    to_port     = 80
    protocol    = "tcp"
    self        = true
  }

  ingress {
    description = "https"
    from_port   = 443
    to_port     = 443
    protocol    = "tcp"
    self        = true
  }

  tags = {
    Name = "grid_router_vpce"
  }
}

####################
# Grid Router Prod #
####################

resource "aws_vpc_endpoint" "grid_router_prod" {
  count              = "${var.enable_grid_router_vpce ? 1 : 0}"
  vpc_id             = "${var.vpc_id}"
  service_name       = "${data.aws_vpc_endpoint_service.grid_router_prod.service_name}"
  vpc_endpoint_type  = "Interface"
  security_group_ids = ["${aws_security_group.hub_instances.id}", "${aws_security_group.grid_router_vpce.id}"]
  subnet_ids = ["${data.aws_subnet.private_a.id}", "${data.aws_subnet.private_b.id}", "${data.aws_subnet.private_c.id}"]

  tags {
    Name = "grid-router-prod"
  }
}

// Redirect requests to api.browsergrid.xarth.tv to the VPC Endpoint
resource "aws_route53_record" "vpce_dns_grid_router_prod" {
  count = "${var.enable_grid_router_vpce ? 1 : 0}"
  name = "api-prod"
  type = "CNAME"
  ttl  = 300
  zone_id = "${aws_route53_zone.browsergrid_xarth.zone_id}"
  records = ["${lookup(aws_vpc_endpoint.grid_router_prod.dns_entry[0], "dns_name")}"]
}

########################
# Grid Router Prod 2XL #
########################

resource "aws_vpc_endpoint" "grid_router_prod_2xl" {
  count              = "${var.enable_grid_router_vpce ? 1 : 0}"
  vpc_id             = "${var.vpc_id}"
  service_name       = "${data.aws_vpc_endpoint_service.grid_router_prod_2xl.service_name}"
  vpc_endpoint_type  = "Interface"
  security_group_ids = ["${aws_security_group.hub_instances.id}", "${aws_security_group.grid_router_vpce.id}"]
  subnet_ids = ["${data.aws_subnet.private_a.id}", "${data.aws_subnet.private_b.id}", "${data.aws_subnet.private_c.id}"]

  tags {
    Name = "grid-router-prod-2xl"
  }
}

// Redirect requests to api.browsergrid.xarth.tv to the VPC Endpoint
resource "aws_route53_record" "vpce_dns_grid_router_prod_2xl" {
  count = "${var.enable_grid_router_vpce ? 1 : 0}"
  name = "api-prod-2xl"
  type = "CNAME"
  ttl  = 300
  zone_id = "${aws_route53_zone.browsergrid_xarth.zone_id}"
  records = ["${lookup(aws_vpc_endpoint.grid_router_prod_2xl.dns_entry[0], "dns_name")}"]
}


###################
# Grid Router Dev #
###################

resource "aws_vpc_endpoint" "grid_router_dev" {
  count              = "${var.enable_grid_router_vpce ? 1 : 0}"
  vpc_id             = "${var.vpc_id}"
  service_name       = "${data.aws_vpc_endpoint_service.grid_router_dev.service_name}"
  vpc_endpoint_type  = "Interface"
  security_group_ids = ["${aws_security_group.hub_instances.id}", "${aws_security_group.grid_router_vpce.id}"]
  subnet_ids = ["${data.aws_subnet.private_a.id}", "${data.aws_subnet.private_b.id}", "${data.aws_subnet.private_c.id}"]

  tags {
    Name = "grid-router-dev"
  }
}

// Redirect requests to api.browsergrid.xarth.tv to the VPC Endpoint
resource "aws_route53_record" "vpce_dns_grid_router_dev" {
  count = "${var.enable_grid_router_vpce ? 1 : 0}"
  name = "api-dev"
  type = "CNAME"
  ttl  = 300
  zone_id = "${aws_route53_zone.browsergrid_xarth.zone_id}"
  records = ["${lookup(aws_vpc_endpoint.grid_router_dev.dns_entry[0], "dns_name")}"]
}

#######################
# Grid Router Dev-Ato #
#######################

resource "aws_vpc_endpoint" "grid_router_dev_ato" {
  count              = "${var.enable_grid_router_dev_vpce ? 1 : 0}"
  vpc_id             = "${var.vpc_id}"
  service_name       = "${data.aws_vpc_endpoint_service.grid_router_dev_ato.service_name}"
  vpc_endpoint_type  = "Interface"
  security_group_ids = ["${aws_security_group.hub_instances.id}", "${aws_security_group.grid_router_vpce.id}"]
  subnet_ids = ["${data.aws_subnet.private_a.id}", "${data.aws_subnet.private_b.id}", "${data.aws_subnet.private_c.id}"]

  tags {
    Name = "grid-router-dev-ato"
  }
}

// Redirect requests to api.browsergrid.xarth.tv to the VPC Endpoint
resource "aws_route53_record" "vpce_dns_grid_router_dev_ato" {
  count = "${var.enable_grid_router_dev_vpce ? 1 : 0}"
  name = "api-dev-ato"
  type = "CNAME"
  ttl  = 300
  zone_id = "${aws_route53_zone.browsergrid_xarth.zone_id}"
  records = ["${lookup(aws_vpc_endpoint.grid_router_dev_ato.dns_entry[0], "dns_name")}"]
}
