// Creates a VPC Endpoint connection with Passport
// https://jira.twitch.com/browse/IDPLAT-3755

// Zone to store Production Passport Route - Legacy Record
// Does not use a top-level twitch.a2z.com so that other a2z records don't route through private zone
resource "aws_route53_zone" "passport_prod_legacy" {
  name = "passport.internal.us-west-2.twitch.tv"
  vpc {
    vpc_id = "${var.vpc_id}"
  }
}

// Zone to store Production Passport Route
resource "aws_route53_zone" "passport_prod_atoz" {
  name = "internal.passport.twitch.a2z.com"
  vpc {
    vpc_id = "${var.vpc_id}"
  }
}

#######################
# Passport Production #
#######################

resource "aws_vpc_endpoint" "passport_prod" {
  vpc_id             = "${var.vpc_id}"
  service_name       = "${var.passport_endpoint_prod}"
  vpc_endpoint_type  = "Interface"
  security_group_ids = ["${aws_security_group.node.id}"]
  subnet_ids = ["${data.aws_subnet.private_a.id}", "${data.aws_subnet.private_b.id}", "${data.aws_subnet.private_c.id}"]

  tags {
    Name = "passport-production"
  }
}

// Redirect requests to passport to the VPC Endpoint
resource "aws_route53_record" "passport_prod" {
  name    = ""
  type    = "A"
  zone_id = "${aws_route53_zone.passport_prod_atoz.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.passport_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.passport_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "passport_prod_legacy" {
  name    = ""
  type    = "A"
  zone_id = "${aws_route53_zone.passport_prod_legacy.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.passport_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.passport_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}
