// Creates a VPC Endpoint connection with Sage
// https://jira.twitch.com/browse/DELIVERY-2389

// Zone to store Twitch.Tech Route (which is used by Sage Test Environment)
resource "aws_route53_zone" "twitch_tech" {
  name = "twitch.tech"
  vpc {
    vpc_id = "${var.vpc_id}"
  }
}

#################
# Sage Test Env #
#################

resource "aws_vpc_endpoint" "sage_test_env" {
  vpc_id             = "${var.vpc_id}"
  service_name       = "${var.sage_endpoint_test_env}"
  vpc_endpoint_type  = "Interface"
  security_group_ids = ["${aws_security_group.node.id}"]
  subnet_ids = ["${data.aws_subnet.private_a.id}", "${data.aws_subnet.private_b.id}", "${data.aws_subnet.private_c.id}"]

  tags {
    Name = "sage-test-env"
  }
}

// Redirect requests to Sage Test Environments to the VPC Endpoint
// examples: main.twitch.tech, pr123.twitch.tech
// wildcard so that all are redirected
resource "aws_route53_record" "sage_test_env" {
  name    = "*"
  type    = "A"
  zone_id = "${aws_route53_zone.twitch_tech.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.sage_test_env.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.sage_test_env.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}
