// Creates a VPC Endpoint connection with Tempo
// https://jira.twitch.com/browse/IPDEL-1838

// Zone to store Production Tempo Route
// Does not use a top-level twitch.a2z.com so that other a2z records don't route through private zone
resource "aws_route53_zone" "tempo_prod" {
  name = "prod.tempo.twitch.a2z.com"
  vpc {
    vpc_id = "${var.vpc_id}"
  }
}

####################
# Tempo Production #
####################

resource "aws_vpc_endpoint" "tempo_prod" {
  vpc_id             = "${var.vpc_id}"
  service_name       = "${var.tempo_endpoint_prod}"
  vpc_endpoint_type  = "Interface"
  security_group_ids = ["${aws_security_group.node.id}"]
  subnet_ids = ["${data.aws_subnet.private_a.id}", "${data.aws_subnet.private_b.id}", "${data.aws_subnet.private_c.id}"]

  tags {
    Name = "tempo-production"
  }
}

// Redirect requests to Tempo to the VPC Endpoint
resource "aws_route53_record" "tempo_prod" {
  name    = ""
  type    = "A"
  zone_id = "${aws_route53_zone.tempo_prod.zone_id}"

  alias {
    name                   = "${lookup(aws_vpc_endpoint.tempo_prod.dns_entry[0], "dns_name")}"
    zone_id                = "${lookup(aws_vpc_endpoint.tempo_prod.dns_entry[0], "hosted_zone_id")}"
    evaluate_target_health = false
  }
}
