# Set up a cloudwatch alarm for memory utilization
resource "aws_cloudwatch_metric_alarm" "memory" {
  alarm_name          = "${aws_elastic_beanstalk_environment.hub.name}-memory-utilization"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "2"
  metric_name         = "MemoryUtilization"
  namespace           = "System/Linux"
  period              = "300"
  statistic           = "Average"
  threshold           = "80"
  dimensions = {
    AutoScalingGroupName = "${aws_elastic_beanstalk_environment.hub.autoscaling_groups[0]}"
  }
  alarm_description = "This metric monitors a beanstalk environment's memory utilization across autoscaling group"
  alarm_actions     = ["${var.sns_arn}"] # Trigger PD Incident
  ok_actions        = ["${var.sns_arn}"] # Resolve PD Incident
  actions_enabled   = "${var.alarms_enabled}"
}

# Health Alarm
resource "aws_cloudwatch_metric_alarm" "env_health" {
  alarm_name          = "${aws_elastic_beanstalk_environment.hub.name}-environment-health"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "EnvironmentHealth"
  namespace           = "AWS/ElasticBeanstalk"
  period              = "60"
  statistic           = "Maximum"
  threshold           = "${var.env_health_threshold}"
  dimensions = {
    EnvironmentName = "${aws_elastic_beanstalk_environment.hub.name}"
  }
  alarm_description = "This metric monitors a beanstalk environment's health by healthcode. 0 (Ok), 1 (Info), 5 (Unknown), 10 (No data), 15 (Warning), 20 (Degraded), 25 (Severe)"
  alarm_actions     = ["${var.sns_arn}"] # Trigger PD Incident
  ok_actions        = ["${var.sns_arn}"] # Resolve PD Incident
  actions_enabled   = "${var.alarms_enabled}"
}

# Disk Space Alarm
resource "aws_cloudwatch_metric_alarm" "disk_util_critical" {
  alarm_name          = "${aws_elastic_beanstalk_environment.hub.name}-disk-util-critical"
  namespace           = "System/Linux"
  metric_name         = "DiskSpaceUtilization"
  statistic           = "Maximum"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  threshold           = "80"
  evaluation_periods  = "2"
  period              = "300" # 5 minutes
  dimensions = {
    AutoScalingGroupName = "${aws_elastic_beanstalk_environment.hub.autoscaling_groups[0]}"
    Filesystem = "/dev/nvme0n1p1"
    MountPath  = "/"
  }
  treat_missing_data = "breaching" # just incase the dimensions (like filesystem) have changed
  alarm_description  = "This metric tracks Disk Free Space as a percentage"
  alarm_actions      = ["${var.sns_arn}"] # Trigger PD Incident
  ok_actions         = ["${var.sns_arn}"] # Resolve PD Incident
  actions_enabled    = "${var.alarms_enabled}"
}
