// Look up the zone to place the new hub record
data "aws_route53_zone" "bg_atoz" {
  provider = "aws.twitch-cape-qe-aws"
  name     = "browsergrid.twitch.a2z.com"
  private_zone = true
}

// Create an atoz record for the hub
// When there is ~NO~ VPC Endpoint, point it to the Beanstalk CNAME
resource "aws_route53_record" "dns_eb_cname" {
  count    = "${var.enable_vpc_endpoint ? 0 : 1}" // If there's ~NO~ VPC Endpoint
  provider = "aws.twitch-cape-qe-aws"
  name     = "hub-${var.environment}-${var.cluster_id}"
  type     = "CNAME"
  ttl      = 300
  zone_id  = "${data.aws_route53_zone.bg_atoz.zone_id}"
  records  = ["${aws_elastic_beanstalk_environment.hub.cname}"]
}

// Create an atoz record for the hub
// When there ~IS~ a VPC Endpoint, Override Grid Router's DNS to point to the VPC Endpoint
resource "aws_route53_record" "vpce_dns" {
  count    = "${var.enable_vpc_endpoint ? 1 : 0}" // If there ~IS~ a VPC Endpoint
  provider = "aws.twitch-cape-qe-aws"
  name     = "hub-${var.environment}-${var.cluster_id}"
  type     = "CNAME"
  ttl      = 300
  zone_id  = "${data.aws_route53_zone.bg_atoz.zone_id}"
  records  = ["${lookup(aws_vpc_endpoint.hub_endpoint_for_grid_router.dns_entry[0], "dns_name")}"]
}
