variable "application_name" {}
variable "environment" {}
variable "cluster_id" {} // The Cluster ID used for naming resources
variable "sns_arn" {} // The SNS Topic used for alerting for cloudwatch alarms
variable "configuration_template_name" {} // The configuration template to use for the environment

/*
The threshold of the Beanstalk Environment at which it alarms
0 (Ok), 1 (Info), 5 (Unknown), 10 (No data), 15 (Warning), 20 (Degraded), 25 (Severe)
*/
variable "env_health_threshold" { // The threshold of the Beanstalk Environment at which it alarms
  default = "20" // 0 (Ok), 1 (Info), 5 (Unknown), 10 (No data), 15 (Warning), 20 (Degraded), 25 (Severe)
}

# Create the environment
resource "aws_elastic_beanstalk_environment" "hub" {
  name          = "grid-hub-${var.environment}-${var.cluster_id}"
  application   = "${var.application_name}"
  template_name = "${var.configuration_template_name}"
  tags {
    Owner            = "reichsta"
    Environment      = "${var.environment}"
    Service          = "grid"
    GridResourceType = "hub"
    GridClusterID    = "${var.cluster_id}"
    SeMajorVersion   = "${var.se_major_version}"
  }
}

# Expose the CNAME
output "cname" {
  value = "${aws_elastic_beanstalk_environment.hub.cname}"
}
