# Ship Logs from Cloudwatch Logs to Elasticsearch

resource "aws_cloudwatch_log_group" "selenium" {
  name = "/aws/elasticbeanstalk/${aws_elastic_beanstalk_environment.hub.name}/selenium"
  retention_in_days = 30
}

// Add a subscription to the cloudwatch log group for the hub's selenium logs
module "selenium_subscription" {
  source = "git::git+ssh://git@git.xarth.tv/qe/cw_es_shipper//terraform/modules/cw_logs_subscription?ref=1.0.0"
  cloudwatch_log_group_name = "${aws_cloudwatch_log_group.selenium.name}"
  lambda_name = "${var.cw_es_shipper_lambda_name}"
}
