variable "cw_es_shipper_lambda_name" {}
variable "vpc_id" {}
variable "subnets" {
  type = "list"
}

variable "se_major_version" { // The major version of Selenium to use (3, 4, etc.)
  default = "3"
}

variable "twitch_cape_qe_aws_vpc_id" {
  default = "vpc-25d89842"
}

variable "twitch_cape_qe_aws_subnets" {
  default = [
    "subnet-cf9a03a8", // Private A
    "subnet-b3b102fa", // Private B
    "subnet-c83d2990", // Private C
  ]
}

variable "enable_vpc_endpoint" {
  default = true
}

// Enable Cloudwatch Alarms
variable "alarms_enabled" {
  default = true
}

// This is a security group Beanstalk may automatically modify to allow permissions
// DO NOT pass something like twitch_subnets to this. Beanstalk may modify that
variable "elb_managed_security_group" {
  type = "string"
}

